package software.amazon.awscdk.interfaces.iotwireless;

/**
 * A reference to a ServiceProfile resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotwireless.*;
 * ServiceProfileReference serviceProfileReference = ServiceProfileReference.builder()
 *         .serviceProfileArn("serviceProfileArn")
 *         .serviceProfileId("serviceProfileId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.736Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotwireless.ServiceProfileReference")
@software.amazon.jsii.Jsii.Proxy(ServiceProfileReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceProfileReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ServiceProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceProfileArn();

    /**
     * The Id of the ServiceProfile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceProfileId();

    /**
     * @return a {@link Builder} of {@link ServiceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceProfileReference> {
        java.lang.String serviceProfileArn;
        java.lang.String serviceProfileId;

        /**
         * Sets the value of {@link ServiceProfileReference#getServiceProfileArn}
         * @param serviceProfileArn The ARN of the ServiceProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceProfileArn(java.lang.String serviceProfileArn) {
            this.serviceProfileArn = serviceProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link ServiceProfileReference#getServiceProfileId}
         * @param serviceProfileId The Id of the ServiceProfile resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceProfileId(java.lang.String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceProfileReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceProfileReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceProfileReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceProfileReference {
        private final java.lang.String serviceProfileArn;
        private final java.lang.String serviceProfileId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceProfileArn = software.amazon.jsii.Kernel.get(this, "serviceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceProfileId = software.amazon.jsii.Kernel.get(this, "serviceProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceProfileArn = java.util.Objects.requireNonNull(builder.serviceProfileArn, "serviceProfileArn is required");
            this.serviceProfileId = java.util.Objects.requireNonNull(builder.serviceProfileId, "serviceProfileId is required");
        }

        @Override
        public final java.lang.String getServiceProfileArn() {
            return this.serviceProfileArn;
        }

        @Override
        public final java.lang.String getServiceProfileId() {
            return this.serviceProfileId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceProfileArn", om.valueToTree(this.getServiceProfileArn()));
            data.set("serviceProfileId", om.valueToTree(this.getServiceProfileId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotwireless.ServiceProfileReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceProfileReference.Jsii$Proxy that = (ServiceProfileReference.Jsii$Proxy) o;

            if (!serviceProfileArn.equals(that.serviceProfileArn)) return false;
            return this.serviceProfileId.equals(that.serviceProfileId);
        }

        @Override
        public final int hashCode() {
            int result = this.serviceProfileArn.hashCode();
            result = 31 * result + (this.serviceProfileId.hashCode());
            return result;
        }
    }
}
