package software.amazon.awscdk.interfaces.iotwireless;

/**
 * A reference to a WirelessDevice resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotwireless.*;
 * WirelessDeviceReference wirelessDeviceReference = WirelessDeviceReference.builder()
 *         .wirelessDeviceArn("wirelessDeviceArn")
 *         .wirelessDeviceId("wirelessDeviceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.737Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotwireless.WirelessDeviceReference")
@software.amazon.jsii.Jsii.Proxy(WirelessDeviceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WirelessDeviceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the WirelessDevice resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWirelessDeviceArn();

    /**
     * The Id of the WirelessDevice resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWirelessDeviceId();

    /**
     * @return a {@link Builder} of {@link WirelessDeviceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WirelessDeviceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WirelessDeviceReference> {
        java.lang.String wirelessDeviceArn;
        java.lang.String wirelessDeviceId;

        /**
         * Sets the value of {@link WirelessDeviceReference#getWirelessDeviceArn}
         * @param wirelessDeviceArn The ARN of the WirelessDevice resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wirelessDeviceArn(java.lang.String wirelessDeviceArn) {
            this.wirelessDeviceArn = wirelessDeviceArn;
            return this;
        }

        /**
         * Sets the value of {@link WirelessDeviceReference#getWirelessDeviceId}
         * @param wirelessDeviceId The Id of the WirelessDevice resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wirelessDeviceId(java.lang.String wirelessDeviceId) {
            this.wirelessDeviceId = wirelessDeviceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WirelessDeviceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WirelessDeviceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WirelessDeviceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WirelessDeviceReference {
        private final java.lang.String wirelessDeviceArn;
        private final java.lang.String wirelessDeviceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.wirelessDeviceArn = software.amazon.jsii.Kernel.get(this, "wirelessDeviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.wirelessDeviceId = software.amazon.jsii.Kernel.get(this, "wirelessDeviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.wirelessDeviceArn = java.util.Objects.requireNonNull(builder.wirelessDeviceArn, "wirelessDeviceArn is required");
            this.wirelessDeviceId = java.util.Objects.requireNonNull(builder.wirelessDeviceId, "wirelessDeviceId is required");
        }

        @Override
        public final java.lang.String getWirelessDeviceArn() {
            return this.wirelessDeviceArn;
        }

        @Override
        public final java.lang.String getWirelessDeviceId() {
            return this.wirelessDeviceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("wirelessDeviceArn", om.valueToTree(this.getWirelessDeviceArn()));
            data.set("wirelessDeviceId", om.valueToTree(this.getWirelessDeviceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotwireless.WirelessDeviceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WirelessDeviceReference.Jsii$Proxy that = (WirelessDeviceReference.Jsii$Proxy) o;

            if (!wirelessDeviceArn.equals(that.wirelessDeviceArn)) return false;
            return this.wirelessDeviceId.equals(that.wirelessDeviceId);
        }

        @Override
        public final int hashCode() {
            int result = this.wirelessDeviceArn.hashCode();
            result = 31 * result + (this.wirelessDeviceId.hashCode());
            return result;
        }
    }
}
