package software.amazon.awscdk.interfaces.iotwireless;

/**
 * A reference to a WirelessGateway resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.iotwireless.*;
 * WirelessGatewayReference wirelessGatewayReference = WirelessGatewayReference.builder()
 *         .wirelessGatewayArn("wirelessGatewayArn")
 *         .wirelessGatewayId("wirelessGatewayId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.737Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_iotwireless.WirelessGatewayReference")
@software.amazon.jsii.Jsii.Proxy(WirelessGatewayReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WirelessGatewayReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the WirelessGateway resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWirelessGatewayArn();

    /**
     * The Id of the WirelessGateway resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWirelessGatewayId();

    /**
     * @return a {@link Builder} of {@link WirelessGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WirelessGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WirelessGatewayReference> {
        java.lang.String wirelessGatewayArn;
        java.lang.String wirelessGatewayId;

        /**
         * Sets the value of {@link WirelessGatewayReference#getWirelessGatewayArn}
         * @param wirelessGatewayArn The ARN of the WirelessGateway resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wirelessGatewayArn(java.lang.String wirelessGatewayArn) {
            this.wirelessGatewayArn = wirelessGatewayArn;
            return this;
        }

        /**
         * Sets the value of {@link WirelessGatewayReference#getWirelessGatewayId}
         * @param wirelessGatewayId The Id of the WirelessGateway resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wirelessGatewayId(java.lang.String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WirelessGatewayReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WirelessGatewayReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WirelessGatewayReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WirelessGatewayReference {
        private final java.lang.String wirelessGatewayArn;
        private final java.lang.String wirelessGatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.wirelessGatewayArn = software.amazon.jsii.Kernel.get(this, "wirelessGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.wirelessGatewayId = software.amazon.jsii.Kernel.get(this, "wirelessGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.wirelessGatewayArn = java.util.Objects.requireNonNull(builder.wirelessGatewayArn, "wirelessGatewayArn is required");
            this.wirelessGatewayId = java.util.Objects.requireNonNull(builder.wirelessGatewayId, "wirelessGatewayId is required");
        }

        @Override
        public final java.lang.String getWirelessGatewayArn() {
            return this.wirelessGatewayArn;
        }

        @Override
        public final java.lang.String getWirelessGatewayId() {
            return this.wirelessGatewayId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("wirelessGatewayArn", om.valueToTree(this.getWirelessGatewayArn()));
            data.set("wirelessGatewayId", om.valueToTree(this.getWirelessGatewayId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_iotwireless.WirelessGatewayReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WirelessGatewayReference.Jsii$Proxy that = (WirelessGatewayReference.Jsii$Proxy) o;

            if (!wirelessGatewayArn.equals(that.wirelessGatewayArn)) return false;
            return this.wirelessGatewayId.equals(that.wirelessGatewayId);
        }

        @Override
        public final int hashCode() {
            int result = this.wirelessGatewayArn.hashCode();
            result = 31 * result + (this.wirelessGatewayId.hashCode());
            return result;
        }
    }
}
