package software.amazon.awscdk.interfaces.ivs;

/**
 * A reference to a PlaybackKeyPair resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.ivs.*;
 * PlaybackKeyPairReference playbackKeyPairReference = PlaybackKeyPairReference.builder()
 *         .playbackKeyPairArn("playbackKeyPairArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.741Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_ivs.PlaybackKeyPairReference")
@software.amazon.jsii.Jsii.Proxy(PlaybackKeyPairReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PlaybackKeyPairReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the PlaybackKeyPair resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPlaybackKeyPairArn();

    /**
     * @return a {@link Builder} of {@link PlaybackKeyPairReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PlaybackKeyPairReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PlaybackKeyPairReference> {
        java.lang.String playbackKeyPairArn;

        /**
         * Sets the value of {@link PlaybackKeyPairReference#getPlaybackKeyPairArn}
         * @param playbackKeyPairArn The Arn of the PlaybackKeyPair resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder playbackKeyPairArn(java.lang.String playbackKeyPairArn) {
            this.playbackKeyPairArn = playbackKeyPairArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PlaybackKeyPairReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PlaybackKeyPairReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PlaybackKeyPairReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlaybackKeyPairReference {
        private final java.lang.String playbackKeyPairArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.playbackKeyPairArn = software.amazon.jsii.Kernel.get(this, "playbackKeyPairArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.playbackKeyPairArn = java.util.Objects.requireNonNull(builder.playbackKeyPairArn, "playbackKeyPairArn is required");
        }

        @Override
        public final java.lang.String getPlaybackKeyPairArn() {
            return this.playbackKeyPairArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("playbackKeyPairArn", om.valueToTree(this.getPlaybackKeyPairArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_ivs.PlaybackKeyPairReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PlaybackKeyPairReference.Jsii$Proxy that = (PlaybackKeyPairReference.Jsii$Proxy) o;

            return this.playbackKeyPairArn.equals(that.playbackKeyPairArn);
        }

        @Override
        public final int hashCode() {
            int result = this.playbackKeyPairArn.hashCode();
            return result;
        }
    }
}
