package software.amazon.awscdk.interfaces.kafkaconnect;

/**
 * A reference to a WorkerConfiguration resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.kafkaconnect.*;
 * WorkerConfigurationReference workerConfigurationReference = WorkerConfigurationReference.builder()
 *         .workerConfigurationArn("workerConfigurationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.746Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_kafkaconnect.WorkerConfigurationReference")
@software.amazon.jsii.Jsii.Proxy(WorkerConfigurationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WorkerConfigurationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The WorkerConfigurationArn of the WorkerConfiguration resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkerConfigurationArn();

    /**
     * @return a {@link Builder} of {@link WorkerConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WorkerConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WorkerConfigurationReference> {
        java.lang.String workerConfigurationArn;

        /**
         * Sets the value of {@link WorkerConfigurationReference#getWorkerConfigurationArn}
         * @param workerConfigurationArn The WorkerConfigurationArn of the WorkerConfiguration resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerConfigurationArn(java.lang.String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WorkerConfigurationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WorkerConfigurationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WorkerConfigurationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkerConfigurationReference {
        private final java.lang.String workerConfigurationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.workerConfigurationArn = software.amazon.jsii.Kernel.get(this, "workerConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.workerConfigurationArn = java.util.Objects.requireNonNull(builder.workerConfigurationArn, "workerConfigurationArn is required");
        }

        @Override
        public final java.lang.String getWorkerConfigurationArn() {
            return this.workerConfigurationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("workerConfigurationArn", om.valueToTree(this.getWorkerConfigurationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_kafkaconnect.WorkerConfigurationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WorkerConfigurationReference.Jsii$Proxy that = (WorkerConfigurationReference.Jsii$Proxy) o;

            return this.workerConfigurationArn.equals(that.workerConfigurationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.workerConfigurationArn.hashCode();
            return result;
        }
    }
}
