package software.amazon.awscdk.interfaces.kendra;

/**
 * A reference to a Index resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.kendra.*;
 * IndexReference indexReference = IndexReference.builder()
 *         .indexArn("indexArn")
 *         .indexId("indexId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.748Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_kendra.IndexReference")
@software.amazon.jsii.Jsii.Proxy(IndexReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IndexReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Index resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexArn();

    /**
     * The Id of the Index resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexId();

    /**
     * @return a {@link Builder} of {@link IndexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IndexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IndexReference> {
        java.lang.String indexArn;
        java.lang.String indexId;

        /**
         * Sets the value of {@link IndexReference#getIndexArn}
         * @param indexArn The ARN of the Index resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexArn(java.lang.String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        /**
         * Sets the value of {@link IndexReference#getIndexId}
         * @param indexId The Id of the Index resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexId(java.lang.String indexId) {
            this.indexId = indexId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IndexReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IndexReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IndexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IndexReference {
        private final java.lang.String indexArn;
        private final java.lang.String indexId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.indexArn = software.amazon.jsii.Kernel.get(this, "indexArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.indexId = software.amazon.jsii.Kernel.get(this, "indexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.indexArn = java.util.Objects.requireNonNull(builder.indexArn, "indexArn is required");
            this.indexId = java.util.Objects.requireNonNull(builder.indexId, "indexId is required");
        }

        @Override
        public final java.lang.String getIndexArn() {
            return this.indexArn;
        }

        @Override
        public final java.lang.String getIndexId() {
            return this.indexId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("indexArn", om.valueToTree(this.getIndexArn()));
            data.set("indexId", om.valueToTree(this.getIndexId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_kendra.IndexReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IndexReference.Jsii$Proxy that = (IndexReference.Jsii$Proxy) o;

            if (!indexArn.equals(that.indexArn)) return false;
            return this.indexId.equals(that.indexId);
        }

        @Override
        public final int hashCode() {
            int result = this.indexArn.hashCode();
            result = 31 * result + (this.indexId.hashCode());
            return result;
        }
    }
}
