package software.amazon.awscdk.interfaces.kendraranking;

/**
 * A reference to a ExecutionPlan resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.kendraranking.*;
 * ExecutionPlanReference executionPlanReference = ExecutionPlanReference.builder()
 *         .executionPlanArn("executionPlanArn")
 *         .executionPlanId("executionPlanId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.748Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_kendraranking.ExecutionPlanReference")
@software.amazon.jsii.Jsii.Proxy(ExecutionPlanReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExecutionPlanReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ExecutionPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionPlanArn();

    /**
     * The Id of the ExecutionPlan resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionPlanId();

    /**
     * @return a {@link Builder} of {@link ExecutionPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExecutionPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExecutionPlanReference> {
        java.lang.String executionPlanArn;
        java.lang.String executionPlanId;

        /**
         * Sets the value of {@link ExecutionPlanReference#getExecutionPlanArn}
         * @param executionPlanArn The ARN of the ExecutionPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionPlanArn(java.lang.String executionPlanArn) {
            this.executionPlanArn = executionPlanArn;
            return this;
        }

        /**
         * Sets the value of {@link ExecutionPlanReference#getExecutionPlanId}
         * @param executionPlanId The Id of the ExecutionPlan resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionPlanId(java.lang.String executionPlanId) {
            this.executionPlanId = executionPlanId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExecutionPlanReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExecutionPlanReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExecutionPlanReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecutionPlanReference {
        private final java.lang.String executionPlanArn;
        private final java.lang.String executionPlanId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executionPlanArn = software.amazon.jsii.Kernel.get(this, "executionPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionPlanId = software.amazon.jsii.Kernel.get(this, "executionPlanId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executionPlanArn = java.util.Objects.requireNonNull(builder.executionPlanArn, "executionPlanArn is required");
            this.executionPlanId = java.util.Objects.requireNonNull(builder.executionPlanId, "executionPlanId is required");
        }

        @Override
        public final java.lang.String getExecutionPlanArn() {
            return this.executionPlanArn;
        }

        @Override
        public final java.lang.String getExecutionPlanId() {
            return this.executionPlanId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("executionPlanArn", om.valueToTree(this.getExecutionPlanArn()));
            data.set("executionPlanId", om.valueToTree(this.getExecutionPlanId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_kendraranking.ExecutionPlanReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExecutionPlanReference.Jsii$Proxy that = (ExecutionPlanReference.Jsii$Proxy) o;

            if (!executionPlanArn.equals(that.executionPlanArn)) return false;
            return this.executionPlanId.equals(that.executionPlanId);
        }

        @Override
        public final int hashCode() {
            int result = this.executionPlanArn.hashCode();
            result = 31 * result + (this.executionPlanId.hashCode());
            return result;
        }
    }
}
