package software.amazon.awscdk.interfaces.kinesisvideo;

/**
 * A reference to a SignalingChannel resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.kinesisvideo.*;
 * SignalingChannelReference signalingChannelReference = SignalingChannelReference.builder()
 *         .signalingChannelArn("signalingChannelArn")
 *         .signalingChannelName("signalingChannelName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.768Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_kinesisvideo.SignalingChannelReference")
@software.amazon.jsii.Jsii.Proxy(SignalingChannelReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SignalingChannelReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the SignalingChannel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSignalingChannelArn();

    /**
     * The Name of the SignalingChannel resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSignalingChannelName();

    /**
     * @return a {@link Builder} of {@link SignalingChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SignalingChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SignalingChannelReference> {
        java.lang.String signalingChannelArn;
        java.lang.String signalingChannelName;

        /**
         * Sets the value of {@link SignalingChannelReference#getSignalingChannelArn}
         * @param signalingChannelArn The ARN of the SignalingChannel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalingChannelArn(java.lang.String signalingChannelArn) {
            this.signalingChannelArn = signalingChannelArn;
            return this;
        }

        /**
         * Sets the value of {@link SignalingChannelReference#getSignalingChannelName}
         * @param signalingChannelName The Name of the SignalingChannel resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalingChannelName(java.lang.String signalingChannelName) {
            this.signalingChannelName = signalingChannelName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SignalingChannelReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SignalingChannelReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SignalingChannelReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignalingChannelReference {
        private final java.lang.String signalingChannelArn;
        private final java.lang.String signalingChannelName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.signalingChannelArn = software.amazon.jsii.Kernel.get(this, "signalingChannelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signalingChannelName = software.amazon.jsii.Kernel.get(this, "signalingChannelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.signalingChannelArn = java.util.Objects.requireNonNull(builder.signalingChannelArn, "signalingChannelArn is required");
            this.signalingChannelName = java.util.Objects.requireNonNull(builder.signalingChannelName, "signalingChannelName is required");
        }

        @Override
        public final java.lang.String getSignalingChannelArn() {
            return this.signalingChannelArn;
        }

        @Override
        public final java.lang.String getSignalingChannelName() {
            return this.signalingChannelName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("signalingChannelArn", om.valueToTree(this.getSignalingChannelArn()));
            data.set("signalingChannelName", om.valueToTree(this.getSignalingChannelName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_kinesisvideo.SignalingChannelReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SignalingChannelReference.Jsii$Proxy that = (SignalingChannelReference.Jsii$Proxy) o;

            if (!signalingChannelArn.equals(that.signalingChannelArn)) return false;
            return this.signalingChannelName.equals(that.signalingChannelName);
        }

        @Override
        public final int hashCode() {
            int result = this.signalingChannelArn.hashCode();
            result = 31 * result + (this.signalingChannelName.hashCode());
            return result;
        }
    }
}
