package software.amazon.awscdk.interfaces.lakeformation;

/**
 * A reference to a DataCellsFilter resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lakeformation.*;
 * DataCellsFilterReference dataCellsFilterReference = DataCellsFilterReference.builder()
 *         .databaseName("databaseName")
 *         .dataCellsFilterName("dataCellsFilterName")
 *         .tableCatalogId("tableCatalogId")
 *         .tableName("tableName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.771Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lakeformation.DataCellsFilterReference")
@software.amazon.jsii.Jsii.Proxy(DataCellsFilterReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataCellsFilterReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DatabaseName of the DataCellsFilter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

    /**
     * The Name of the DataCellsFilter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataCellsFilterName();

    /**
     * The TableCatalogId of the DataCellsFilter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableCatalogId();

    /**
     * The TableName of the DataCellsFilter resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * @return a {@link Builder} of {@link DataCellsFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataCellsFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataCellsFilterReference> {
        java.lang.String databaseName;
        java.lang.String dataCellsFilterName;
        java.lang.String tableCatalogId;
        java.lang.String tableName;

        /**
         * Sets the value of {@link DataCellsFilterReference#getDatabaseName}
         * @param databaseName The DatabaseName of the DataCellsFilter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link DataCellsFilterReference#getDataCellsFilterName}
         * @param dataCellsFilterName The Name of the DataCellsFilter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCellsFilterName(java.lang.String dataCellsFilterName) {
            this.dataCellsFilterName = dataCellsFilterName;
            return this;
        }

        /**
         * Sets the value of {@link DataCellsFilterReference#getTableCatalogId}
         * @param tableCatalogId The TableCatalogId of the DataCellsFilter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableCatalogId(java.lang.String tableCatalogId) {
            this.tableCatalogId = tableCatalogId;
            return this;
        }

        /**
         * Sets the value of {@link DataCellsFilterReference#getTableName}
         * @param tableName The TableName of the DataCellsFilter resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataCellsFilterReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataCellsFilterReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataCellsFilterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCellsFilterReference {
        private final java.lang.String databaseName;
        private final java.lang.String dataCellsFilterName;
        private final java.lang.String tableCatalogId;
        private final java.lang.String tableName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataCellsFilterName = software.amazon.jsii.Kernel.get(this, "dataCellsFilterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableCatalogId = software.amazon.jsii.Kernel.get(this, "tableCatalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            this.dataCellsFilterName = java.util.Objects.requireNonNull(builder.dataCellsFilterName, "dataCellsFilterName is required");
            this.tableCatalogId = java.util.Objects.requireNonNull(builder.tableCatalogId, "tableCatalogId is required");
            this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.String getDataCellsFilterName() {
            return this.dataCellsFilterName;
        }

        @Override
        public final java.lang.String getTableCatalogId() {
            return this.tableCatalogId;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            data.set("dataCellsFilterName", om.valueToTree(this.getDataCellsFilterName()));
            data.set("tableCatalogId", om.valueToTree(this.getTableCatalogId()));
            data.set("tableName", om.valueToTree(this.getTableName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lakeformation.DataCellsFilterReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataCellsFilterReference.Jsii$Proxy that = (DataCellsFilterReference.Jsii$Proxy) o;

            if (!databaseName.equals(that.databaseName)) return false;
            if (!dataCellsFilterName.equals(that.dataCellsFilterName)) return false;
            if (!tableCatalogId.equals(that.tableCatalogId)) return false;
            return this.tableName.equals(that.tableName);
        }

        @Override
        public final int hashCode() {
            int result = this.databaseName.hashCode();
            result = 31 * result + (this.dataCellsFilterName.hashCode());
            result = 31 * result + (this.tableCatalogId.hashCode());
            result = 31 * result + (this.tableName.hashCode());
            return result;
        }
    }
}
