package software.amazon.awscdk.interfaces.lakeformation;

/**
 * A reference to a PrincipalPermissions resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lakeformation.*;
 * PrincipalPermissionsReference principalPermissionsReference = PrincipalPermissionsReference.builder()
 *         .principalIdentifier("principalIdentifier")
 *         .resourceIdentifier("resourceIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.774Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lakeformation.PrincipalPermissionsReference")
@software.amazon.jsii.Jsii.Proxy(PrincipalPermissionsReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PrincipalPermissionsReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The PrincipalIdentifier of the PrincipalPermissions resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipalIdentifier();

    /**
     * The ResourceIdentifier of the PrincipalPermissions resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceIdentifier();

    /**
     * @return a {@link Builder} of {@link PrincipalPermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PrincipalPermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PrincipalPermissionsReference> {
        java.lang.String principalIdentifier;
        java.lang.String resourceIdentifier;

        /**
         * Sets the value of {@link PrincipalPermissionsReference#getPrincipalIdentifier}
         * @param principalIdentifier The PrincipalIdentifier of the PrincipalPermissions resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalIdentifier(java.lang.String principalIdentifier) {
            this.principalIdentifier = principalIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link PrincipalPermissionsReference#getResourceIdentifier}
         * @param resourceIdentifier The ResourceIdentifier of the PrincipalPermissions resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(java.lang.String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PrincipalPermissionsReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PrincipalPermissionsReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PrincipalPermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrincipalPermissionsReference {
        private final java.lang.String principalIdentifier;
        private final java.lang.String resourceIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.principalIdentifier = software.amazon.jsii.Kernel.get(this, "principalIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceIdentifier = software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.principalIdentifier = java.util.Objects.requireNonNull(builder.principalIdentifier, "principalIdentifier is required");
            this.resourceIdentifier = java.util.Objects.requireNonNull(builder.resourceIdentifier, "resourceIdentifier is required");
        }

        @Override
        public final java.lang.String getPrincipalIdentifier() {
            return this.principalIdentifier;
        }

        @Override
        public final java.lang.String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("principalIdentifier", om.valueToTree(this.getPrincipalIdentifier()));
            data.set("resourceIdentifier", om.valueToTree(this.getResourceIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lakeformation.PrincipalPermissionsReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PrincipalPermissionsReference.Jsii$Proxy that = (PrincipalPermissionsReference.Jsii$Proxy) o;

            if (!principalIdentifier.equals(that.principalIdentifier)) return false;
            return this.resourceIdentifier.equals(that.resourceIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.principalIdentifier.hashCode();
            result = 31 * result + (this.resourceIdentifier.hashCode());
            return result;
        }
    }
}
