package software.amazon.awscdk.interfaces.lex;

/**
 * A reference to a Bot resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lex.*;
 * BotReference botReference = BotReference.builder()
 *         .botArn("botArn")
 *         .botId("botId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.782Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lex.BotReference")
@software.amazon.jsii.Jsii.Proxy(BotReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BotReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Bot resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBotArn();

    /**
     * The Id of the Bot resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBotId();

    /**
     * @return a {@link Builder} of {@link BotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BotReference> {
        java.lang.String botArn;
        java.lang.String botId;

        /**
         * Sets the value of {@link BotReference#getBotArn}
         * @param botArn The ARN of the Bot resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botArn(java.lang.String botArn) {
            this.botArn = botArn;
            return this;
        }

        /**
         * Sets the value of {@link BotReference#getBotId}
         * @param botId The Id of the Bot resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botId(java.lang.String botId) {
            this.botId = botId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BotReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BotReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BotReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotReference {
        private final java.lang.String botArn;
        private final java.lang.String botId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.botArn = software.amazon.jsii.Kernel.get(this, "botArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.botId = software.amazon.jsii.Kernel.get(this, "botId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.botArn = java.util.Objects.requireNonNull(builder.botArn, "botArn is required");
            this.botId = java.util.Objects.requireNonNull(builder.botId, "botId is required");
        }

        @Override
        public final java.lang.String getBotArn() {
            return this.botArn;
        }

        @Override
        public final java.lang.String getBotId() {
            return this.botId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("botArn", om.valueToTree(this.getBotArn()));
            data.set("botId", om.valueToTree(this.getBotId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lex.BotReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BotReference.Jsii$Proxy that = (BotReference.Jsii$Proxy) o;

            if (!botArn.equals(that.botArn)) return false;
            return this.botId.equals(that.botId);
        }

        @Override
        public final int hashCode() {
            int result = this.botArn.hashCode();
            result = 31 * result + (this.botId.hashCode());
            return result;
        }
    }
}
