package software.amazon.awscdk.interfaces.location;

/**
 * A reference to a GeofenceCollection resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.location.*;
 * GeofenceCollectionReference geofenceCollectionReference = GeofenceCollectionReference.builder()
 *         .collectionName("collectionName")
 *         .geofenceCollectionArn("geofenceCollectionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.806Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_location.GeofenceCollectionReference")
@software.amazon.jsii.Jsii.Proxy(GeofenceCollectionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GeofenceCollectionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CollectionName of the GeofenceCollection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCollectionName();

    /**
     * The ARN of the GeofenceCollection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGeofenceCollectionArn();

    /**
     * @return a {@link Builder} of {@link GeofenceCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GeofenceCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GeofenceCollectionReference> {
        java.lang.String collectionName;
        java.lang.String geofenceCollectionArn;

        /**
         * Sets the value of {@link GeofenceCollectionReference#getCollectionName}
         * @param collectionName The CollectionName of the GeofenceCollection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionName(java.lang.String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        /**
         * Sets the value of {@link GeofenceCollectionReference#getGeofenceCollectionArn}
         * @param geofenceCollectionArn The ARN of the GeofenceCollection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geofenceCollectionArn(java.lang.String geofenceCollectionArn) {
            this.geofenceCollectionArn = geofenceCollectionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GeofenceCollectionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GeofenceCollectionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GeofenceCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeofenceCollectionReference {
        private final java.lang.String collectionName;
        private final java.lang.String geofenceCollectionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.collectionName = software.amazon.jsii.Kernel.get(this, "collectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.geofenceCollectionArn = software.amazon.jsii.Kernel.get(this, "geofenceCollectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.collectionName = java.util.Objects.requireNonNull(builder.collectionName, "collectionName is required");
            this.geofenceCollectionArn = java.util.Objects.requireNonNull(builder.geofenceCollectionArn, "geofenceCollectionArn is required");
        }

        @Override
        public final java.lang.String getCollectionName() {
            return this.collectionName;
        }

        @Override
        public final java.lang.String getGeofenceCollectionArn() {
            return this.geofenceCollectionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("collectionName", om.valueToTree(this.getCollectionName()));
            data.set("geofenceCollectionArn", om.valueToTree(this.getGeofenceCollectionArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_location.GeofenceCollectionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GeofenceCollectionReference.Jsii$Proxy that = (GeofenceCollectionReference.Jsii$Proxy) o;

            if (!collectionName.equals(that.collectionName)) return false;
            return this.geofenceCollectionArn.equals(that.geofenceCollectionArn);
        }

        @Override
        public final int hashCode() {
            int result = this.collectionName.hashCode();
            result = 31 * result + (this.geofenceCollectionArn.hashCode());
            return result;
        }
    }
}
