package software.amazon.awscdk.interfaces.location;

/**
 * A reference to a PlaceIndex resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.location.*;
 * PlaceIndexReference placeIndexReference = PlaceIndexReference.builder()
 *         .indexName("indexName")
 *         .placeIndexArn("placeIndexArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.809Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_location.PlaceIndexReference")
@software.amazon.jsii.Jsii.Proxy(PlaceIndexReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PlaceIndexReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IndexName of the PlaceIndex resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

    /**
     * The ARN of the PlaceIndex resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPlaceIndexArn();

    /**
     * @return a {@link Builder} of {@link PlaceIndexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PlaceIndexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PlaceIndexReference> {
        java.lang.String indexName;
        java.lang.String placeIndexArn;

        /**
         * Sets the value of {@link PlaceIndexReference#getIndexName}
         * @param indexName The IndexName of the PlaceIndex resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of {@link PlaceIndexReference#getPlaceIndexArn}
         * @param placeIndexArn The ARN of the PlaceIndex resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placeIndexArn(java.lang.String placeIndexArn) {
            this.placeIndexArn = placeIndexArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PlaceIndexReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PlaceIndexReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PlaceIndexReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlaceIndexReference {
        private final java.lang.String indexName;
        private final java.lang.String placeIndexArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.placeIndexArn = software.amazon.jsii.Kernel.get(this, "placeIndexArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
            this.placeIndexArn = java.util.Objects.requireNonNull(builder.placeIndexArn, "placeIndexArn is required");
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public final java.lang.String getPlaceIndexArn() {
            return this.placeIndexArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("indexName", om.valueToTree(this.getIndexName()));
            data.set("placeIndexArn", om.valueToTree(this.getPlaceIndexArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_location.PlaceIndexReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PlaceIndexReference.Jsii$Proxy that = (PlaceIndexReference.Jsii$Proxy) o;

            if (!indexName.equals(that.indexName)) return false;
            return this.placeIndexArn.equals(that.placeIndexArn);
        }

        @Override
        public final int hashCode() {
            int result = this.indexName.hashCode();
            result = 31 * result + (this.placeIndexArn.hashCode());
            return result;
        }
    }
}
