package software.amazon.awscdk.interfaces.lookoutvision;

/**
 * A reference to a Project resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.lookoutvision.*;
 * ProjectReference projectReference = ProjectReference.builder()
 *         .projectArn("projectArn")
 *         .projectName("projectName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.821Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_lookoutvision.ProjectReference")
@software.amazon.jsii.Jsii.Proxy(ProjectReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProjectReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Project resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectArn();

    /**
     * The ProjectName of the Project resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectName();

    /**
     * @return a {@link Builder} of {@link ProjectReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProjectReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProjectReference> {
        java.lang.String projectArn;
        java.lang.String projectName;

        /**
         * Sets the value of {@link ProjectReference#getProjectArn}
         * @param projectArn The ARN of the Project resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectArn(java.lang.String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        /**
         * Sets the value of {@link ProjectReference#getProjectName}
         * @param projectName The ProjectName of the Project resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProjectReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProjectReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProjectReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectReference {
        private final java.lang.String projectArn;
        private final java.lang.String projectName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.projectArn = software.amazon.jsii.Kernel.get(this, "projectArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.projectArn = java.util.Objects.requireNonNull(builder.projectArn, "projectArn is required");
            this.projectName = java.util.Objects.requireNonNull(builder.projectName, "projectName is required");
        }

        @Override
        public final java.lang.String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("projectArn", om.valueToTree(this.getProjectArn()));
            data.set("projectName", om.valueToTree(this.getProjectName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_lookoutvision.ProjectReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProjectReference.Jsii$Proxy that = (ProjectReference.Jsii$Proxy) o;

            if (!projectArn.equals(that.projectArn)) return false;
            return this.projectName.equals(that.projectName);
        }

        @Override
        public final int hashCode() {
            int result = this.projectArn.hashCode();
            result = 31 * result + (this.projectName.hashCode());
            return result;
        }
    }
}
