package software.amazon.awscdk.interfaces.mediaconnect;

/**
 * A reference to a BridgeSource resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.mediaconnect.*;
 * BridgeSourceReference bridgeSourceReference = BridgeSourceReference.builder()
 *         .bridgeArn("bridgeArn")
 *         .bridgeSourceName("bridgeSourceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.840Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_mediaconnect.BridgeSourceReference")
@software.amazon.jsii.Jsii.Proxy(BridgeSourceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BridgeSourceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The BridgeArn of the BridgeSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBridgeArn();

    /**
     * The Name of the BridgeSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBridgeSourceName();

    /**
     * @return a {@link Builder} of {@link BridgeSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BridgeSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BridgeSourceReference> {
        java.lang.String bridgeArn;
        java.lang.String bridgeSourceName;

        /**
         * Sets the value of {@link BridgeSourceReference#getBridgeArn}
         * @param bridgeArn The BridgeArn of the BridgeSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bridgeArn(java.lang.String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        /**
         * Sets the value of {@link BridgeSourceReference#getBridgeSourceName}
         * @param bridgeSourceName The Name of the BridgeSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bridgeSourceName(java.lang.String bridgeSourceName) {
            this.bridgeSourceName = bridgeSourceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BridgeSourceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BridgeSourceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BridgeSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BridgeSourceReference {
        private final java.lang.String bridgeArn;
        private final java.lang.String bridgeSourceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bridgeArn = software.amazon.jsii.Kernel.get(this, "bridgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bridgeSourceName = software.amazon.jsii.Kernel.get(this, "bridgeSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bridgeArn = java.util.Objects.requireNonNull(builder.bridgeArn, "bridgeArn is required");
            this.bridgeSourceName = java.util.Objects.requireNonNull(builder.bridgeSourceName, "bridgeSourceName is required");
        }

        @Override
        public final java.lang.String getBridgeArn() {
            return this.bridgeArn;
        }

        @Override
        public final java.lang.String getBridgeSourceName() {
            return this.bridgeSourceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bridgeArn", om.valueToTree(this.getBridgeArn()));
            data.set("bridgeSourceName", om.valueToTree(this.getBridgeSourceName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_mediaconnect.BridgeSourceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BridgeSourceReference.Jsii$Proxy that = (BridgeSourceReference.Jsii$Proxy) o;

            if (!bridgeArn.equals(that.bridgeArn)) return false;
            return this.bridgeSourceName.equals(that.bridgeSourceName);
        }

        @Override
        public final int hashCode() {
            int result = this.bridgeArn.hashCode();
            result = 31 * result + (this.bridgeSourceName.hashCode());
            return result;
        }
    }
}
