package software.amazon.awscdk.interfaces.mediaconnect;

/**
 * A reference to a FlowVpcInterface resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.mediaconnect.*;
 * FlowVpcInterfaceReference flowVpcInterfaceReference = FlowVpcInterfaceReference.builder()
 *         .flowArn("flowArn")
 *         .flowVpcInterfaceName("flowVpcInterfaceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.841Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_mediaconnect.FlowVpcInterfaceReference")
@software.amazon.jsii.Jsii.Proxy(FlowVpcInterfaceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FlowVpcInterfaceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The FlowArn of the FlowVpcInterface resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFlowArn();

    /**
     * The Name of the FlowVpcInterface resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFlowVpcInterfaceName();

    /**
     * @return a {@link Builder} of {@link FlowVpcInterfaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FlowVpcInterfaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FlowVpcInterfaceReference> {
        java.lang.String flowArn;
        java.lang.String flowVpcInterfaceName;

        /**
         * Sets the value of {@link FlowVpcInterfaceReference#getFlowArn}
         * @param flowArn The FlowArn of the FlowVpcInterface resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowArn(java.lang.String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        /**
         * Sets the value of {@link FlowVpcInterfaceReference#getFlowVpcInterfaceName}
         * @param flowVpcInterfaceName The Name of the FlowVpcInterface resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowVpcInterfaceName(java.lang.String flowVpcInterfaceName) {
            this.flowVpcInterfaceName = flowVpcInterfaceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FlowVpcInterfaceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FlowVpcInterfaceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FlowVpcInterfaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowVpcInterfaceReference {
        private final java.lang.String flowArn;
        private final java.lang.String flowVpcInterfaceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.flowArn = software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flowVpcInterfaceName = software.amazon.jsii.Kernel.get(this, "flowVpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.flowArn = java.util.Objects.requireNonNull(builder.flowArn, "flowArn is required");
            this.flowVpcInterfaceName = java.util.Objects.requireNonNull(builder.flowVpcInterfaceName, "flowVpcInterfaceName is required");
        }

        @Override
        public final java.lang.String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final java.lang.String getFlowVpcInterfaceName() {
            return this.flowVpcInterfaceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("flowArn", om.valueToTree(this.getFlowArn()));
            data.set("flowVpcInterfaceName", om.valueToTree(this.getFlowVpcInterfaceName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_mediaconnect.FlowVpcInterfaceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FlowVpcInterfaceReference.Jsii$Proxy that = (FlowVpcInterfaceReference.Jsii$Proxy) o;

            if (!flowArn.equals(that.flowArn)) return false;
            return this.flowVpcInterfaceName.equals(that.flowVpcInterfaceName);
        }

        @Override
        public final int hashCode() {
            int result = this.flowArn.hashCode();
            result = 31 * result + (this.flowVpcInterfaceName.hashCode());
            return result;
        }
    }
}
