package software.amazon.awscdk.interfaces.medialive;

/**
 * A reference to a ChannelPlacementGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.medialive.*;
 * ChannelPlacementGroupReference channelPlacementGroupReference = ChannelPlacementGroupReference.builder()
 *         .channelPlacementGroupArn("channelPlacementGroupArn")
 *         .channelPlacementGroupId("channelPlacementGroupId")
 *         .clusterId("clusterId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.848Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_medialive.ChannelPlacementGroupReference")
@software.amazon.jsii.Jsii.Proxy(ChannelPlacementGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ChannelPlacementGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ChannelPlacementGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelPlacementGroupArn();

    /**
     * The Id of the ChannelPlacementGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelPlacementGroupId();

    /**
     * The ClusterId of the ChannelPlacementGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterId();

    /**
     * @return a {@link Builder} of {@link ChannelPlacementGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ChannelPlacementGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ChannelPlacementGroupReference> {
        java.lang.String channelPlacementGroupArn;
        java.lang.String channelPlacementGroupId;
        java.lang.String clusterId;

        /**
         * Sets the value of {@link ChannelPlacementGroupReference#getChannelPlacementGroupArn}
         * @param channelPlacementGroupArn The ARN of the ChannelPlacementGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelPlacementGroupArn(java.lang.String channelPlacementGroupArn) {
            this.channelPlacementGroupArn = channelPlacementGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link ChannelPlacementGroupReference#getChannelPlacementGroupId}
         * @param channelPlacementGroupId The Id of the ChannelPlacementGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelPlacementGroupId(java.lang.String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
            return this;
        }

        /**
         * Sets the value of {@link ChannelPlacementGroupReference#getClusterId}
         * @param clusterId The ClusterId of the ChannelPlacementGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ChannelPlacementGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ChannelPlacementGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ChannelPlacementGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelPlacementGroupReference {
        private final java.lang.String channelPlacementGroupArn;
        private final java.lang.String channelPlacementGroupId;
        private final java.lang.String clusterId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelPlacementGroupArn = software.amazon.jsii.Kernel.get(this, "channelPlacementGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.channelPlacementGroupId = software.amazon.jsii.Kernel.get(this, "channelPlacementGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterId = software.amazon.jsii.Kernel.get(this, "clusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelPlacementGroupArn = java.util.Objects.requireNonNull(builder.channelPlacementGroupArn, "channelPlacementGroupArn is required");
            this.channelPlacementGroupId = java.util.Objects.requireNonNull(builder.channelPlacementGroupId, "channelPlacementGroupId is required");
            this.clusterId = java.util.Objects.requireNonNull(builder.clusterId, "clusterId is required");
        }

        @Override
        public final java.lang.String getChannelPlacementGroupArn() {
            return this.channelPlacementGroupArn;
        }

        @Override
        public final java.lang.String getChannelPlacementGroupId() {
            return this.channelPlacementGroupId;
        }

        @Override
        public final java.lang.String getClusterId() {
            return this.clusterId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelPlacementGroupArn", om.valueToTree(this.getChannelPlacementGroupArn()));
            data.set("channelPlacementGroupId", om.valueToTree(this.getChannelPlacementGroupId()));
            data.set("clusterId", om.valueToTree(this.getClusterId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_medialive.ChannelPlacementGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ChannelPlacementGroupReference.Jsii$Proxy that = (ChannelPlacementGroupReference.Jsii$Proxy) o;

            if (!channelPlacementGroupArn.equals(that.channelPlacementGroupArn)) return false;
            if (!channelPlacementGroupId.equals(that.channelPlacementGroupId)) return false;
            return this.clusterId.equals(that.clusterId);
        }

        @Override
        public final int hashCode() {
            int result = this.channelPlacementGroupArn.hashCode();
            result = 31 * result + (this.channelPlacementGroupId.hashCode());
            result = 31 * result + (this.clusterId.hashCode());
            return result;
        }
    }
}
