package software.amazon.awscdk.interfaces.mediatailor;

/**
 * A reference to a LiveSource resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.mediatailor.*;
 * LiveSourceReference liveSourceReference = LiveSourceReference.builder()
 *         .liveSourceArn("liveSourceArn")
 *         .liveSourceName("liveSourceName")
 *         .sourceLocationName("sourceLocationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.878Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_mediatailor.LiveSourceReference")
@software.amazon.jsii.Jsii.Proxy(LiveSourceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LiveSourceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the LiveSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLiveSourceArn();

    /**
     * The LiveSourceName of the LiveSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLiveSourceName();

    /**
     * The SourceLocationName of the LiveSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationName();

    /**
     * @return a {@link Builder} of {@link LiveSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LiveSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LiveSourceReference> {
        java.lang.String liveSourceArn;
        java.lang.String liveSourceName;
        java.lang.String sourceLocationName;

        /**
         * Sets the value of {@link LiveSourceReference#getLiveSourceArn}
         * @param liveSourceArn The ARN of the LiveSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveSourceArn(java.lang.String liveSourceArn) {
            this.liveSourceArn = liveSourceArn;
            return this;
        }

        /**
         * Sets the value of {@link LiveSourceReference#getLiveSourceName}
         * @param liveSourceName The LiveSourceName of the LiveSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveSourceName(java.lang.String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        /**
         * Sets the value of {@link LiveSourceReference#getSourceLocationName}
         * @param sourceLocationName The SourceLocationName of the LiveSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationName(java.lang.String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LiveSourceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LiveSourceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LiveSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LiveSourceReference {
        private final java.lang.String liveSourceArn;
        private final java.lang.String liveSourceName;
        private final java.lang.String sourceLocationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.liveSourceArn = software.amazon.jsii.Kernel.get(this, "liveSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.liveSourceName = software.amazon.jsii.Kernel.get(this, "liveSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceLocationName = software.amazon.jsii.Kernel.get(this, "sourceLocationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.liveSourceArn = java.util.Objects.requireNonNull(builder.liveSourceArn, "liveSourceArn is required");
            this.liveSourceName = java.util.Objects.requireNonNull(builder.liveSourceName, "liveSourceName is required");
            this.sourceLocationName = java.util.Objects.requireNonNull(builder.sourceLocationName, "sourceLocationName is required");
        }

        @Override
        public final java.lang.String getLiveSourceArn() {
            return this.liveSourceArn;
        }

        @Override
        public final java.lang.String getLiveSourceName() {
            return this.liveSourceName;
        }

        @Override
        public final java.lang.String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("liveSourceArn", om.valueToTree(this.getLiveSourceArn()));
            data.set("liveSourceName", om.valueToTree(this.getLiveSourceName()));
            data.set("sourceLocationName", om.valueToTree(this.getSourceLocationName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_mediatailor.LiveSourceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LiveSourceReference.Jsii$Proxy that = (LiveSourceReference.Jsii$Proxy) o;

            if (!liveSourceArn.equals(that.liveSourceArn)) return false;
            if (!liveSourceName.equals(that.liveSourceName)) return false;
            return this.sourceLocationName.equals(that.sourceLocationName);
        }

        @Override
        public final int hashCode() {
            int result = this.liveSourceArn.hashCode();
            result = 31 * result + (this.liveSourceName.hashCode());
            result = 31 * result + (this.sourceLocationName.hashCode());
            return result;
        }
    }
}
