package software.amazon.awscdk.interfaces.mediatailor;

/**
 * A reference to a VodSource resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.mediatailor.*;
 * VodSourceReference vodSourceReference = VodSourceReference.builder()
 *         .sourceLocationName("sourceLocationName")
 *         .vodSourceArn("vodSourceArn")
 *         .vodSourceName("vodSourceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.879Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_mediatailor.VodSourceReference")
@software.amazon.jsii.Jsii.Proxy(VodSourceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VodSourceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The SourceLocationName of the VodSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationName();

    /**
     * The ARN of the VodSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVodSourceArn();

    /**
     * The VodSourceName of the VodSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVodSourceName();

    /**
     * @return a {@link Builder} of {@link VodSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VodSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VodSourceReference> {
        java.lang.String sourceLocationName;
        java.lang.String vodSourceArn;
        java.lang.String vodSourceName;

        /**
         * Sets the value of {@link VodSourceReference#getSourceLocationName}
         * @param sourceLocationName The SourceLocationName of the VodSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationName(java.lang.String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        /**
         * Sets the value of {@link VodSourceReference#getVodSourceArn}
         * @param vodSourceArn The ARN of the VodSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vodSourceArn(java.lang.String vodSourceArn) {
            this.vodSourceArn = vodSourceArn;
            return this;
        }

        /**
         * Sets the value of {@link VodSourceReference#getVodSourceName}
         * @param vodSourceName The VodSourceName of the VodSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vodSourceName(java.lang.String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VodSourceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VodSourceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VodSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VodSourceReference {
        private final java.lang.String sourceLocationName;
        private final java.lang.String vodSourceArn;
        private final java.lang.String vodSourceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceLocationName = software.amazon.jsii.Kernel.get(this, "sourceLocationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vodSourceArn = software.amazon.jsii.Kernel.get(this, "vodSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vodSourceName = software.amazon.jsii.Kernel.get(this, "vodSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceLocationName = java.util.Objects.requireNonNull(builder.sourceLocationName, "sourceLocationName is required");
            this.vodSourceArn = java.util.Objects.requireNonNull(builder.vodSourceArn, "vodSourceArn is required");
            this.vodSourceName = java.util.Objects.requireNonNull(builder.vodSourceName, "vodSourceName is required");
        }

        @Override
        public final java.lang.String getSourceLocationName() {
            return this.sourceLocationName;
        }

        @Override
        public final java.lang.String getVodSourceArn() {
            return this.vodSourceArn;
        }

        @Override
        public final java.lang.String getVodSourceName() {
            return this.vodSourceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceLocationName", om.valueToTree(this.getSourceLocationName()));
            data.set("vodSourceArn", om.valueToTree(this.getVodSourceArn()));
            data.set("vodSourceName", om.valueToTree(this.getVodSourceName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_mediatailor.VodSourceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VodSourceReference.Jsii$Proxy that = (VodSourceReference.Jsii$Proxy) o;

            if (!sourceLocationName.equals(that.sourceLocationName)) return false;
            if (!vodSourceArn.equals(that.vodSourceArn)) return false;
            return this.vodSourceName.equals(that.vodSourceName);
        }

        @Override
        public final int hashCode() {
            int result = this.sourceLocationName.hashCode();
            result = 31 * result + (this.vodSourceArn.hashCode());
            result = 31 * result + (this.vodSourceName.hashCode());
            return result;
        }
    }
}
