package software.amazon.awscdk.interfaces.memorydb;

/**
 * A reference to a MultiRegionCluster resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.memorydb.*;
 * MultiRegionClusterReference multiRegionClusterReference = MultiRegionClusterReference.builder()
 *         .multiRegionClusterArn("multiRegionClusterArn")
 *         .multiRegionClusterName("multiRegionClusterName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.882Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_memorydb.MultiRegionClusterReference")
@software.amazon.jsii.Jsii.Proxy(MultiRegionClusterReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MultiRegionClusterReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the MultiRegionCluster resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMultiRegionClusterArn();

    /**
     * The MultiRegionClusterName of the MultiRegionCluster resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMultiRegionClusterName();

    /**
     * @return a {@link Builder} of {@link MultiRegionClusterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MultiRegionClusterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MultiRegionClusterReference> {
        java.lang.String multiRegionClusterArn;
        java.lang.String multiRegionClusterName;

        /**
         * Sets the value of {@link MultiRegionClusterReference#getMultiRegionClusterArn}
         * @param multiRegionClusterArn The ARN of the MultiRegionCluster resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionClusterArn(java.lang.String multiRegionClusterArn) {
            this.multiRegionClusterArn = multiRegionClusterArn;
            return this;
        }

        /**
         * Sets the value of {@link MultiRegionClusterReference#getMultiRegionClusterName}
         * @param multiRegionClusterName The MultiRegionClusterName of the MultiRegionCluster resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionClusterName(java.lang.String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MultiRegionClusterReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MultiRegionClusterReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MultiRegionClusterReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiRegionClusterReference {
        private final java.lang.String multiRegionClusterArn;
        private final java.lang.String multiRegionClusterName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.multiRegionClusterArn = software.amazon.jsii.Kernel.get(this, "multiRegionClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiRegionClusterName = software.amazon.jsii.Kernel.get(this, "multiRegionClusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.multiRegionClusterArn = java.util.Objects.requireNonNull(builder.multiRegionClusterArn, "multiRegionClusterArn is required");
            this.multiRegionClusterName = java.util.Objects.requireNonNull(builder.multiRegionClusterName, "multiRegionClusterName is required");
        }

        @Override
        public final java.lang.String getMultiRegionClusterArn() {
            return this.multiRegionClusterArn;
        }

        @Override
        public final java.lang.String getMultiRegionClusterName() {
            return this.multiRegionClusterName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("multiRegionClusterArn", om.valueToTree(this.getMultiRegionClusterArn()));
            data.set("multiRegionClusterName", om.valueToTree(this.getMultiRegionClusterName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_memorydb.MultiRegionClusterReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MultiRegionClusterReference.Jsii$Proxy that = (MultiRegionClusterReference.Jsii$Proxy) o;

            if (!multiRegionClusterArn.equals(that.multiRegionClusterArn)) return false;
            return this.multiRegionClusterName.equals(that.multiRegionClusterName);
        }

        @Override
        public final int hashCode() {
            int result = this.multiRegionClusterArn.hashCode();
            result = 31 * result + (this.multiRegionClusterName.hashCode());
            return result;
        }
    }
}
