package software.amazon.awscdk.interfaces.msk;

/**
 * A reference to a VpcConnection resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.msk.*;
 * VpcConnectionReference vpcConnectionReference = VpcConnectionReference.builder()
 *         .vpcConnectionArn("vpcConnectionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.888Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_msk.VpcConnectionReference")
@software.amazon.jsii.Jsii.Proxy(VpcConnectionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcConnectionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the VpcConnection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcConnectionArn();

    /**
     * @return a {@link Builder} of {@link VpcConnectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcConnectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcConnectionReference> {
        java.lang.String vpcConnectionArn;

        /**
         * Sets the value of {@link VpcConnectionReference#getVpcConnectionArn}
         * @param vpcConnectionArn The Arn of the VpcConnection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConnectionArn(java.lang.String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcConnectionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcConnectionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcConnectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConnectionReference {
        private final java.lang.String vpcConnectionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcConnectionArn = software.amazon.jsii.Kernel.get(this, "vpcConnectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcConnectionArn = java.util.Objects.requireNonNull(builder.vpcConnectionArn, "vpcConnectionArn is required");
        }

        @Override
        public final java.lang.String getVpcConnectionArn() {
            return this.vpcConnectionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcConnectionArn", om.valueToTree(this.getVpcConnectionArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_msk.VpcConnectionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcConnectionReference.Jsii$Proxy that = (VpcConnectionReference.Jsii$Proxy) o;

            return this.vpcConnectionArn.equals(that.vpcConnectionArn);
        }

        @Override
        public final int hashCode() {
            int result = this.vpcConnectionArn.hashCode();
            return result;
        }
    }
}
