package software.amazon.awscdk.interfaces.networkmanager;

/**
 * A reference to a Site resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.networkmanager.*;
 * SiteReference siteReference = SiteReference.builder()
 *         .globalNetworkId("globalNetworkId")
 *         .siteArn("siteArn")
 *         .siteId("siteId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.917Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_networkmanager.SiteReference")
@software.amazon.jsii.Jsii.Proxy(SiteReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SiteReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The GlobalNetworkId of the Site resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlobalNetworkId();

    /**
     * The ARN of the Site resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSiteArn();

    /**
     * The SiteId of the Site resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSiteId();

    /**
     * @return a {@link Builder} of {@link SiteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SiteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SiteReference> {
        java.lang.String globalNetworkId;
        java.lang.String siteArn;
        java.lang.String siteId;

        /**
         * Sets the value of {@link SiteReference#getGlobalNetworkId}
         * @param globalNetworkId The GlobalNetworkId of the Site resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNetworkId(java.lang.String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link SiteReference#getSiteArn}
         * @param siteArn The ARN of the Site resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder siteArn(java.lang.String siteArn) {
            this.siteArn = siteArn;
            return this;
        }

        /**
         * Sets the value of {@link SiteReference#getSiteId}
         * @param siteId The SiteId of the Site resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder siteId(java.lang.String siteId) {
            this.siteId = siteId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SiteReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SiteReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SiteReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SiteReference {
        private final java.lang.String globalNetworkId;
        private final java.lang.String siteArn;
        private final java.lang.String siteId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.globalNetworkId = software.amazon.jsii.Kernel.get(this, "globalNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.siteArn = software.amazon.jsii.Kernel.get(this, "siteArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.siteId = software.amazon.jsii.Kernel.get(this, "siteId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.globalNetworkId = java.util.Objects.requireNonNull(builder.globalNetworkId, "globalNetworkId is required");
            this.siteArn = java.util.Objects.requireNonNull(builder.siteArn, "siteArn is required");
            this.siteId = java.util.Objects.requireNonNull(builder.siteId, "siteId is required");
        }

        @Override
        public final java.lang.String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        @Override
        public final java.lang.String getSiteArn() {
            return this.siteArn;
        }

        @Override
        public final java.lang.String getSiteId() {
            return this.siteId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("globalNetworkId", om.valueToTree(this.getGlobalNetworkId()));
            data.set("siteArn", om.valueToTree(this.getSiteArn()));
            data.set("siteId", om.valueToTree(this.getSiteId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_networkmanager.SiteReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SiteReference.Jsii$Proxy that = (SiteReference.Jsii$Proxy) o;

            if (!globalNetworkId.equals(that.globalNetworkId)) return false;
            if (!siteArn.equals(that.siteArn)) return false;
            return this.siteId.equals(that.siteId);
        }

        @Override
        public final int hashCode() {
            int result = this.globalNetworkId.hashCode();
            result = 31 * result + (this.siteArn.hashCode());
            result = 31 * result + (this.siteId.hashCode());
            return result;
        }
    }
}
