package software.amazon.awscdk.interfaces.notifications;

/**
 * A reference to a ChannelAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.notifications.*;
 * ChannelAssociationReference channelAssociationReference = ChannelAssociationReference.builder()
 *         .channelAssociationArn("channelAssociationArn")
 *         .notificationConfigurationArn("notificationConfigurationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.921Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_notifications.ChannelAssociationReference")
@software.amazon.jsii.Jsii.Proxy(ChannelAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ChannelAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the ChannelAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelAssociationArn();

    /**
     * The NotificationConfigurationArn of the ChannelAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNotificationConfigurationArn();

    /**
     * @return a {@link Builder} of {@link ChannelAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ChannelAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ChannelAssociationReference> {
        java.lang.String channelAssociationArn;
        java.lang.String notificationConfigurationArn;

        /**
         * Sets the value of {@link ChannelAssociationReference#getChannelAssociationArn}
         * @param channelAssociationArn The Arn of the ChannelAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelAssociationArn(java.lang.String channelAssociationArn) {
            this.channelAssociationArn = channelAssociationArn;
            return this;
        }

        /**
         * Sets the value of {@link ChannelAssociationReference#getNotificationConfigurationArn}
         * @param notificationConfigurationArn The NotificationConfigurationArn of the ChannelAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfigurationArn(java.lang.String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ChannelAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ChannelAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ChannelAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelAssociationReference {
        private final java.lang.String channelAssociationArn;
        private final java.lang.String notificationConfigurationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelAssociationArn = software.amazon.jsii.Kernel.get(this, "channelAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationConfigurationArn = software.amazon.jsii.Kernel.get(this, "notificationConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelAssociationArn = java.util.Objects.requireNonNull(builder.channelAssociationArn, "channelAssociationArn is required");
            this.notificationConfigurationArn = java.util.Objects.requireNonNull(builder.notificationConfigurationArn, "notificationConfigurationArn is required");
        }

        @Override
        public final java.lang.String getChannelAssociationArn() {
            return this.channelAssociationArn;
        }

        @Override
        public final java.lang.String getNotificationConfigurationArn() {
            return this.notificationConfigurationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelAssociationArn", om.valueToTree(this.getChannelAssociationArn()));
            data.set("notificationConfigurationArn", om.valueToTree(this.getNotificationConfigurationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_notifications.ChannelAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ChannelAssociationReference.Jsii$Proxy that = (ChannelAssociationReference.Jsii$Proxy) o;

            if (!channelAssociationArn.equals(that.channelAssociationArn)) return false;
            return this.notificationConfigurationArn.equals(that.notificationConfigurationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.channelAssociationArn.hashCode();
            result = 31 * result + (this.notificationConfigurationArn.hashCode());
            return result;
        }
    }
}
