package software.amazon.awscdk.interfaces.notifications;

/**
 * A reference to a ManagedNotificationAdditionalChannelAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.notifications.*;
 * ManagedNotificationAdditionalChannelAssociationReference managedNotificationAdditionalChannelAssociationReference = ManagedNotificationAdditionalChannelAssociationReference.builder()
 *         .channelArn("channelArn")
 *         .managedNotificationConfigurationArn("managedNotificationConfigurationArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.924Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_notifications.ManagedNotificationAdditionalChannelAssociationReference")
@software.amazon.jsii.Jsii.Proxy(ManagedNotificationAdditionalChannelAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManagedNotificationAdditionalChannelAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ChannelArn of the ManagedNotificationAdditionalChannelAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelArn();

    /**
     * The ManagedNotificationConfigurationArn of the ManagedNotificationAdditionalChannelAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getManagedNotificationConfigurationArn();

    /**
     * @return a {@link Builder} of {@link ManagedNotificationAdditionalChannelAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ManagedNotificationAdditionalChannelAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ManagedNotificationAdditionalChannelAssociationReference> {
        java.lang.String channelArn;
        java.lang.String managedNotificationConfigurationArn;

        /**
         * Sets the value of {@link ManagedNotificationAdditionalChannelAssociationReference#getChannelArn}
         * @param channelArn The ChannelArn of the ManagedNotificationAdditionalChannelAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelArn(java.lang.String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        /**
         * Sets the value of {@link ManagedNotificationAdditionalChannelAssociationReference#getManagedNotificationConfigurationArn}
         * @param managedNotificationConfigurationArn The ManagedNotificationConfigurationArn of the ManagedNotificationAdditionalChannelAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedNotificationConfigurationArn(java.lang.String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManagedNotificationAdditionalChannelAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ManagedNotificationAdditionalChannelAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ManagedNotificationAdditionalChannelAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedNotificationAdditionalChannelAssociationReference {
        private final java.lang.String channelArn;
        private final java.lang.String managedNotificationConfigurationArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelArn = software.amazon.jsii.Kernel.get(this, "channelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.managedNotificationConfigurationArn = software.amazon.jsii.Kernel.get(this, "managedNotificationConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelArn = java.util.Objects.requireNonNull(builder.channelArn, "channelArn is required");
            this.managedNotificationConfigurationArn = java.util.Objects.requireNonNull(builder.managedNotificationConfigurationArn, "managedNotificationConfigurationArn is required");
        }

        @Override
        public final java.lang.String getChannelArn() {
            return this.channelArn;
        }

        @Override
        public final java.lang.String getManagedNotificationConfigurationArn() {
            return this.managedNotificationConfigurationArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelArn", om.valueToTree(this.getChannelArn()));
            data.set("managedNotificationConfigurationArn", om.valueToTree(this.getManagedNotificationConfigurationArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_notifications.ManagedNotificationAdditionalChannelAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ManagedNotificationAdditionalChannelAssociationReference.Jsii$Proxy that = (ManagedNotificationAdditionalChannelAssociationReference.Jsii$Proxy) o;

            if (!channelArn.equals(that.channelArn)) return false;
            return this.managedNotificationConfigurationArn.equals(that.managedNotificationConfigurationArn);
        }

        @Override
        public final int hashCode() {
            int result = this.channelArn.hashCode();
            result = 31 * result + (this.managedNotificationConfigurationArn.hashCode());
            return result;
        }
    }
}
