package software.amazon.awscdk.interfaces.omics;

/**
 * A reference to a RunGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.omics.*;
 * RunGroupReference runGroupReference = RunGroupReference.builder()
 *         .runGroupArn("runGroupArn")
 *         .runGroupId("runGroupId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.935Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_omics.RunGroupReference")
@software.amazon.jsii.Jsii.Proxy(RunGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RunGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the RunGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRunGroupArn();

    /**
     * The Id of the RunGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRunGroupId();

    /**
     * @return a {@link Builder} of {@link RunGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RunGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RunGroupReference> {
        java.lang.String runGroupArn;
        java.lang.String runGroupId;

        /**
         * Sets the value of {@link RunGroupReference#getRunGroupArn}
         * @param runGroupArn The ARN of the RunGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runGroupArn(java.lang.String runGroupArn) {
            this.runGroupArn = runGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link RunGroupReference#getRunGroupId}
         * @param runGroupId The Id of the RunGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runGroupId(java.lang.String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RunGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RunGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RunGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunGroupReference {
        private final java.lang.String runGroupArn;
        private final java.lang.String runGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.runGroupArn = software.amazon.jsii.Kernel.get(this, "runGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runGroupId = software.amazon.jsii.Kernel.get(this, "runGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.runGroupArn = java.util.Objects.requireNonNull(builder.runGroupArn, "runGroupArn is required");
            this.runGroupId = java.util.Objects.requireNonNull(builder.runGroupId, "runGroupId is required");
        }

        @Override
        public final java.lang.String getRunGroupArn() {
            return this.runGroupArn;
        }

        @Override
        public final java.lang.String getRunGroupId() {
            return this.runGroupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("runGroupArn", om.valueToTree(this.getRunGroupArn()));
            data.set("runGroupId", om.valueToTree(this.getRunGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_omics.RunGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RunGroupReference.Jsii$Proxy that = (RunGroupReference.Jsii$Proxy) o;

            if (!runGroupArn.equals(that.runGroupArn)) return false;
            return this.runGroupId.equals(that.runGroupId);
        }

        @Override
        public final int hashCode() {
            int result = this.runGroupArn.hashCode();
            result = 31 * result + (this.runGroupId.hashCode());
            return result;
        }
    }
}
