/**
 * <h1>CDK Resource Interfaces</h1>
 * <p>
 * This module contains resource interfaces for all AWS service resources.
 * <p>
 * These are interfaces that look like this:
 * <p>
 * <blockquote><pre>
 * /**
 *  * Indicates that this resource can be referenced as a Bucket.
 *  *&#47;
 * interface IBucketRef {
 *   /**
 *    * A reference to a Bucket resource.
 *    *&#47;
 *   readonly bucketRef: BucketReference;
 * }
 * 
 * interface BucketReference {
 *   /**
 *    * The BucketName of the Bucket resource.
 *    *&#47;
 *   readonly bucketName: string;
 * 
 *   /**
 *    * The ARN of the Bucket resource.
 *    *&#47;
 *   readonly bucketArn: string;
 * }
 * </pre></blockquote>
 * <p>
 * These are in a separate submodule so that they can be referenced from all other
 * service submodules without introducing cyclic dependencies between them.
 */
package software.amazon.awscdk.interfaces;
