package software.amazon.awscdk.interfaces.panorama;

/**
 * A reference to a ApplicationInstance resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.panorama.*;
 * ApplicationInstanceReference applicationInstanceReference = ApplicationInstanceReference.builder()
 *         .applicationInstanceArn("applicationInstanceArn")
 *         .applicationInstanceId("applicationInstanceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.962Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_panorama.ApplicationInstanceReference")
@software.amazon.jsii.Jsii.Proxy(ApplicationInstanceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationInstanceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ApplicationInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationInstanceArn();

    /**
     * The ApplicationInstanceId of the ApplicationInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationInstanceId();

    /**
     * @return a {@link Builder} of {@link ApplicationInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationInstanceReference> {
        java.lang.String applicationInstanceArn;
        java.lang.String applicationInstanceId;

        /**
         * Sets the value of {@link ApplicationInstanceReference#getApplicationInstanceArn}
         * @param applicationInstanceArn The ARN of the ApplicationInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationInstanceArn(java.lang.String applicationInstanceArn) {
            this.applicationInstanceArn = applicationInstanceArn;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationInstanceReference#getApplicationInstanceId}
         * @param applicationInstanceId The ApplicationInstanceId of the ApplicationInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationInstanceId(java.lang.String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationInstanceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationInstanceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationInstanceReference {
        private final java.lang.String applicationInstanceArn;
        private final java.lang.String applicationInstanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationInstanceArn = software.amazon.jsii.Kernel.get(this, "applicationInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationInstanceId = software.amazon.jsii.Kernel.get(this, "applicationInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationInstanceArn = java.util.Objects.requireNonNull(builder.applicationInstanceArn, "applicationInstanceArn is required");
            this.applicationInstanceId = java.util.Objects.requireNonNull(builder.applicationInstanceId, "applicationInstanceId is required");
        }

        @Override
        public final java.lang.String getApplicationInstanceArn() {
            return this.applicationInstanceArn;
        }

        @Override
        public final java.lang.String getApplicationInstanceId() {
            return this.applicationInstanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationInstanceArn", om.valueToTree(this.getApplicationInstanceArn()));
            data.set("applicationInstanceId", om.valueToTree(this.getApplicationInstanceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_panorama.ApplicationInstanceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationInstanceReference.Jsii$Proxy that = (ApplicationInstanceReference.Jsii$Proxy) o;

            if (!applicationInstanceArn.equals(that.applicationInstanceArn)) return false;
            return this.applicationInstanceId.equals(that.applicationInstanceId);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationInstanceArn.hashCode();
            result = 31 * result + (this.applicationInstanceId.hashCode());
            return result;
        }
    }
}
