package software.amazon.awscdk.interfaces.panorama;

/**
 * A reference to a Package resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.panorama.*;
 * PackageReference packageReference = PackageReference.builder()
 *         .packageArn("packageArn")
 *         .packageId("packageId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.963Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_panorama.PackageReference")
@software.amazon.jsii.Jsii.Proxy(PackageReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PackageReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Package resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackageArn();

    /**
     * The PackageId of the Package resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackageId();

    /**
     * @return a {@link Builder} of {@link PackageReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PackageReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PackageReference> {
        java.lang.String packageArn;
        java.lang.String packageId;

        /**
         * Sets the value of {@link PackageReference#getPackageArn}
         * @param packageArn The ARN of the Package resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageArn(java.lang.String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        /**
         * Sets the value of {@link PackageReference#getPackageId}
         * @param packageId The PackageId of the Package resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageId(java.lang.String packageId) {
            this.packageId = packageId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PackageReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PackageReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PackageReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PackageReference {
        private final java.lang.String packageArn;
        private final java.lang.String packageId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.packageArn = software.amazon.jsii.Kernel.get(this, "packageArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packageId = software.amazon.jsii.Kernel.get(this, "packageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.packageArn = java.util.Objects.requireNonNull(builder.packageArn, "packageArn is required");
            this.packageId = java.util.Objects.requireNonNull(builder.packageId, "packageId is required");
        }

        @Override
        public final java.lang.String getPackageArn() {
            return this.packageArn;
        }

        @Override
        public final java.lang.String getPackageId() {
            return this.packageId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("packageArn", om.valueToTree(this.getPackageArn()));
            data.set("packageId", om.valueToTree(this.getPackageId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_panorama.PackageReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PackageReference.Jsii$Proxy that = (PackageReference.Jsii$Proxy) o;

            if (!packageArn.equals(that.packageArn)) return false;
            return this.packageId.equals(that.packageId);
        }

        @Override
        public final int hashCode() {
            int result = this.packageArn.hashCode();
            result = 31 * result + (this.packageId.hashCode());
            return result;
        }
    }
}
