package software.amazon.awscdk.interfaces.pcaconnectorad;

/**
 * A reference to a TemplateGroupAccessControlEntry resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.pcaconnectorad.*;
 * TemplateGroupAccessControlEntryReference templateGroupAccessControlEntryReference = TemplateGroupAccessControlEntryReference.builder()
 *         .groupSecurityIdentifier("groupSecurityIdentifier")
 *         .templateArn("templateArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.967Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_pcaconnectorad.TemplateGroupAccessControlEntryReference")
@software.amazon.jsii.Jsii.Proxy(TemplateGroupAccessControlEntryReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TemplateGroupAccessControlEntryReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The GroupSecurityIdentifier of the TemplateGroupAccessControlEntry resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupSecurityIdentifier();

    /**
     * The TemplateArn of the TemplateGroupAccessControlEntry resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateArn();

    /**
     * @return a {@link Builder} of {@link TemplateGroupAccessControlEntryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TemplateGroupAccessControlEntryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TemplateGroupAccessControlEntryReference> {
        java.lang.String groupSecurityIdentifier;
        java.lang.String templateArn;

        /**
         * Sets the value of {@link TemplateGroupAccessControlEntryReference#getGroupSecurityIdentifier}
         * @param groupSecurityIdentifier The GroupSecurityIdentifier of the TemplateGroupAccessControlEntry resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupSecurityIdentifier(java.lang.String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link TemplateGroupAccessControlEntryReference#getTemplateArn}
         * @param templateArn The TemplateArn of the TemplateGroupAccessControlEntry resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateArn(java.lang.String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TemplateGroupAccessControlEntryReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TemplateGroupAccessControlEntryReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TemplateGroupAccessControlEntryReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateGroupAccessControlEntryReference {
        private final java.lang.String groupSecurityIdentifier;
        private final java.lang.String templateArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupSecurityIdentifier = software.amazon.jsii.Kernel.get(this, "groupSecurityIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateArn = software.amazon.jsii.Kernel.get(this, "templateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupSecurityIdentifier = java.util.Objects.requireNonNull(builder.groupSecurityIdentifier, "groupSecurityIdentifier is required");
            this.templateArn = java.util.Objects.requireNonNull(builder.templateArn, "templateArn is required");
        }

        @Override
        public final java.lang.String getGroupSecurityIdentifier() {
            return this.groupSecurityIdentifier;
        }

        @Override
        public final java.lang.String getTemplateArn() {
            return this.templateArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupSecurityIdentifier", om.valueToTree(this.getGroupSecurityIdentifier()));
            data.set("templateArn", om.valueToTree(this.getTemplateArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_pcaconnectorad.TemplateGroupAccessControlEntryReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TemplateGroupAccessControlEntryReference.Jsii$Proxy that = (TemplateGroupAccessControlEntryReference.Jsii$Proxy) o;

            if (!groupSecurityIdentifier.equals(that.groupSecurityIdentifier)) return false;
            return this.templateArn.equals(that.templateArn);
        }

        @Override
        public final int hashCode() {
            int result = this.groupSecurityIdentifier.hashCode();
            result = 31 * result + (this.templateArn.hashCode());
            return result;
        }
    }
}
