package software.amazon.awscdk.interfaces.pinpoint;

/**
 * A reference to a EmailTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.pinpoint.*;
 * EmailTemplateReference emailTemplateReference = EmailTemplateReference.builder()
 *         .emailTemplateArn("emailTemplateArn")
 *         .emailTemplateId("emailTemplateId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.976Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_pinpoint.EmailTemplateReference")
@software.amazon.jsii.Jsii.Proxy(EmailTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EmailTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the EmailTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEmailTemplateArn();

    /**
     * The Id of the EmailTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEmailTemplateId();

    /**
     * @return a {@link Builder} of {@link EmailTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmailTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EmailTemplateReference> {
        java.lang.String emailTemplateArn;
        java.lang.String emailTemplateId;

        /**
         * Sets the value of {@link EmailTemplateReference#getEmailTemplateArn}
         * @param emailTemplateArn The ARN of the EmailTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailTemplateArn(java.lang.String emailTemplateArn) {
            this.emailTemplateArn = emailTemplateArn;
            return this;
        }

        /**
         * Sets the value of {@link EmailTemplateReference#getEmailTemplateId}
         * @param emailTemplateId The Id of the EmailTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailTemplateId(java.lang.String emailTemplateId) {
            this.emailTemplateId = emailTemplateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmailTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EmailTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EmailTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailTemplateReference {
        private final java.lang.String emailTemplateArn;
        private final java.lang.String emailTemplateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.emailTemplateArn = software.amazon.jsii.Kernel.get(this, "emailTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.emailTemplateId = software.amazon.jsii.Kernel.get(this, "emailTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.emailTemplateArn = java.util.Objects.requireNonNull(builder.emailTemplateArn, "emailTemplateArn is required");
            this.emailTemplateId = java.util.Objects.requireNonNull(builder.emailTemplateId, "emailTemplateId is required");
        }

        @Override
        public final java.lang.String getEmailTemplateArn() {
            return this.emailTemplateArn;
        }

        @Override
        public final java.lang.String getEmailTemplateId() {
            return this.emailTemplateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("emailTemplateArn", om.valueToTree(this.getEmailTemplateArn()));
            data.set("emailTemplateId", om.valueToTree(this.getEmailTemplateId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_pinpoint.EmailTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmailTemplateReference.Jsii$Proxy that = (EmailTemplateReference.Jsii$Proxy) o;

            if (!emailTemplateArn.equals(that.emailTemplateArn)) return false;
            return this.emailTemplateId.equals(that.emailTemplateId);
        }

        @Override
        public final int hashCode() {
            int result = this.emailTemplateArn.hashCode();
            result = 31 * result + (this.emailTemplateId.hashCode());
            return result;
        }
    }
}
