package software.amazon.awscdk.interfaces.pinpoint;

/**
 * A reference to a Segment resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.pinpoint.*;
 * SegmentReference segmentReference = SegmentReference.builder()
 *         .segmentArn("segmentArn")
 *         .segmentId("segmentId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.994Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_pinpoint.SegmentReference")
@software.amazon.jsii.Jsii.Proxy(SegmentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SegmentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Segment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSegmentArn();

    /**
     * The SegmentId of the Segment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSegmentId();

    /**
     * @return a {@link Builder} of {@link SegmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SegmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SegmentReference> {
        java.lang.String segmentArn;
        java.lang.String segmentId;

        /**
         * Sets the value of {@link SegmentReference#getSegmentArn}
         * @param segmentArn The ARN of the Segment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentArn(java.lang.String segmentArn) {
            this.segmentArn = segmentArn;
            return this;
        }

        /**
         * Sets the value of {@link SegmentReference#getSegmentId}
         * @param segmentId The SegmentId of the Segment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentId(java.lang.String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SegmentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SegmentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SegmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SegmentReference {
        private final java.lang.String segmentArn;
        private final java.lang.String segmentId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.segmentArn = software.amazon.jsii.Kernel.get(this, "segmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.segmentId = software.amazon.jsii.Kernel.get(this, "segmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.segmentArn = java.util.Objects.requireNonNull(builder.segmentArn, "segmentArn is required");
            this.segmentId = java.util.Objects.requireNonNull(builder.segmentId, "segmentId is required");
        }

        @Override
        public final java.lang.String getSegmentArn() {
            return this.segmentArn;
        }

        @Override
        public final java.lang.String getSegmentId() {
            return this.segmentId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("segmentArn", om.valueToTree(this.getSegmentArn()));
            data.set("segmentId", om.valueToTree(this.getSegmentId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_pinpoint.SegmentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SegmentReference.Jsii$Proxy that = (SegmentReference.Jsii$Proxy) o;

            if (!segmentArn.equals(that.segmentArn)) return false;
            return this.segmentId.equals(that.segmentId);
        }

        @Override
        public final int hashCode() {
            int result = this.segmentArn.hashCode();
            result = 31 * result + (this.segmentId.hashCode());
            return result;
        }
    }
}
