package software.amazon.awscdk.interfaces.pinpoint;

/**
 * A reference to a SmsTemplate resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.pinpoint.*;
 * SmsTemplateReference smsTemplateReference = SmsTemplateReference.builder()
 *         .smsTemplateArn("smsTemplateArn")
 *         .smsTemplateId("smsTemplateId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.994Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_pinpoint.SmsTemplateReference")
@software.amazon.jsii.Jsii.Proxy(SmsTemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SmsTemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the SmsTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSmsTemplateArn();

    /**
     * The Id of the SmsTemplate resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSmsTemplateId();

    /**
     * @return a {@link Builder} of {@link SmsTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SmsTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SmsTemplateReference> {
        java.lang.String smsTemplateArn;
        java.lang.String smsTemplateId;

        /**
         * Sets the value of {@link SmsTemplateReference#getSmsTemplateArn}
         * @param smsTemplateArn The ARN of the SmsTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsTemplateArn(java.lang.String smsTemplateArn) {
            this.smsTemplateArn = smsTemplateArn;
            return this;
        }

        /**
         * Sets the value of {@link SmsTemplateReference#getSmsTemplateId}
         * @param smsTemplateId The Id of the SmsTemplate resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsTemplateId(java.lang.String smsTemplateId) {
            this.smsTemplateId = smsTemplateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SmsTemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SmsTemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SmsTemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsTemplateReference {
        private final java.lang.String smsTemplateArn;
        private final java.lang.String smsTemplateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.smsTemplateArn = software.amazon.jsii.Kernel.get(this, "smsTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.smsTemplateId = software.amazon.jsii.Kernel.get(this, "smsTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.smsTemplateArn = java.util.Objects.requireNonNull(builder.smsTemplateArn, "smsTemplateArn is required");
            this.smsTemplateId = java.util.Objects.requireNonNull(builder.smsTemplateId, "smsTemplateId is required");
        }

        @Override
        public final java.lang.String getSmsTemplateArn() {
            return this.smsTemplateArn;
        }

        @Override
        public final java.lang.String getSmsTemplateId() {
            return this.smsTemplateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("smsTemplateArn", om.valueToTree(this.getSmsTemplateArn()));
            data.set("smsTemplateId", om.valueToTree(this.getSmsTemplateId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_pinpoint.SmsTemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SmsTemplateReference.Jsii$Proxy that = (SmsTemplateReference.Jsii$Proxy) o;

            if (!smsTemplateArn.equals(that.smsTemplateArn)) return false;
            return this.smsTemplateId.equals(that.smsTemplateId);
        }

        @Override
        public final int hashCode() {
            int result = this.smsTemplateArn.hashCode();
            result = 31 * result + (this.smsTemplateId.hashCode());
            return result;
        }
    }
}
