package software.amazon.awscdk.interfaces.pipes;

/**
 * A reference to a Pipe resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.pipes.*;
 * PipeReference pipeReference = PipeReference.builder()
 *         .pipeArn("pipeArn")
 *         .pipeName("pipeName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:32.997Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_pipes.PipeReference")
@software.amazon.jsii.Jsii.Proxy(PipeReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PipeReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Pipe resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPipeArn();

    /**
     * The Name of the Pipe resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPipeName();

    /**
     * @return a {@link Builder} of {@link PipeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PipeReference> {
        java.lang.String pipeArn;
        java.lang.String pipeName;

        /**
         * Sets the value of {@link PipeReference#getPipeArn}
         * @param pipeArn The ARN of the Pipe resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipeArn(java.lang.String pipeArn) {
            this.pipeArn = pipeArn;
            return this;
        }

        /**
         * Sets the value of {@link PipeReference#getPipeName}
         * @param pipeName The Name of the Pipe resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipeName(java.lang.String pipeName) {
            this.pipeName = pipeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipeReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PipeReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PipeReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeReference {
        private final java.lang.String pipeArn;
        private final java.lang.String pipeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.pipeArn = software.amazon.jsii.Kernel.get(this, "pipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pipeName = software.amazon.jsii.Kernel.get(this, "pipeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.pipeArn = java.util.Objects.requireNonNull(builder.pipeArn, "pipeArn is required");
            this.pipeName = java.util.Objects.requireNonNull(builder.pipeName, "pipeName is required");
        }

        @Override
        public final java.lang.String getPipeArn() {
            return this.pipeArn;
        }

        @Override
        public final java.lang.String getPipeName() {
            return this.pipeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("pipeArn", om.valueToTree(this.getPipeArn()));
            data.set("pipeName", om.valueToTree(this.getPipeName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_pipes.PipeReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipeReference.Jsii$Proxy that = (PipeReference.Jsii$Proxy) o;

            if (!pipeArn.equals(that.pipeArn)) return false;
            return this.pipeName.equals(that.pipeName);
        }

        @Override
        public final int hashCode() {
            int result = this.pipeArn.hashCode();
            result = 31 * result + (this.pipeName.hashCode());
            return result;
        }
    }
}
