package software.amazon.awscdk.interfaces.qbusiness;

/**
 * A reference to a DataAccessor resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.qbusiness.*;
 * DataAccessorReference dataAccessorReference = DataAccessorReference.builder()
 *         .applicationId("applicationId")
 *         .dataAccessorArn("dataAccessorArn")
 *         .dataAccessorId("dataAccessorId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.000Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_qbusiness.DataAccessorReference")
@software.amazon.jsii.Jsii.Proxy(DataAccessorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataAccessorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ApplicationId of the DataAccessor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The ARN of the DataAccessor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataAccessorArn();

    /**
     * The DataAccessorId of the DataAccessor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataAccessorId();

    /**
     * @return a {@link Builder} of {@link DataAccessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataAccessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataAccessorReference> {
        java.lang.String applicationId;
        java.lang.String dataAccessorArn;
        java.lang.String dataAccessorId;

        /**
         * Sets the value of {@link DataAccessorReference#getApplicationId}
         * @param applicationId The ApplicationId of the DataAccessor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link DataAccessorReference#getDataAccessorArn}
         * @param dataAccessorArn The ARN of the DataAccessor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataAccessorArn(java.lang.String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
            return this;
        }

        /**
         * Sets the value of {@link DataAccessorReference#getDataAccessorId}
         * @param dataAccessorId The DataAccessorId of the DataAccessor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataAccessorId(java.lang.String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataAccessorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataAccessorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataAccessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataAccessorReference {
        private final java.lang.String applicationId;
        private final java.lang.String dataAccessorArn;
        private final java.lang.String dataAccessorId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataAccessorArn = software.amazon.jsii.Kernel.get(this, "dataAccessorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataAccessorId = software.amazon.jsii.Kernel.get(this, "dataAccessorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.dataAccessorArn = java.util.Objects.requireNonNull(builder.dataAccessorArn, "dataAccessorArn is required");
            this.dataAccessorId = java.util.Objects.requireNonNull(builder.dataAccessorId, "dataAccessorId is required");
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getDataAccessorArn() {
            return this.dataAccessorArn;
        }

        @Override
        public final java.lang.String getDataAccessorId() {
            return this.dataAccessorId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("dataAccessorArn", om.valueToTree(this.getDataAccessorArn()));
            data.set("dataAccessorId", om.valueToTree(this.getDataAccessorId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_qbusiness.DataAccessorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataAccessorReference.Jsii$Proxy that = (DataAccessorReference.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!dataAccessorArn.equals(that.dataAccessorArn)) return false;
            return this.dataAccessorId.equals(that.dataAccessorId);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.dataAccessorArn.hashCode());
            result = 31 * result + (this.dataAccessorId.hashCode());
            return result;
        }
    }
}
