package software.amazon.awscdk.interfaces.quicksight;

/**
 * A reference to a CustomPermissions resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.quicksight.*;
 * CustomPermissionsReference customPermissionsReference = CustomPermissionsReference.builder()
 *         .awsAccountId("awsAccountId")
 *         .customPermissionsArn("customPermissionsArn")
 *         .customPermissionsName("customPermissionsName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.007Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_quicksight.CustomPermissionsReference")
@software.amazon.jsii.Jsii.Proxy(CustomPermissionsReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomPermissionsReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AwsAccountId of the CustomPermissions resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The ARN of the CustomPermissions resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomPermissionsArn();

    /**
     * The CustomPermissionsName of the CustomPermissions resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomPermissionsName();

    /**
     * @return a {@link Builder} of {@link CustomPermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomPermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomPermissionsReference> {
        java.lang.String awsAccountId;
        java.lang.String customPermissionsArn;
        java.lang.String customPermissionsName;

        /**
         * Sets the value of {@link CustomPermissionsReference#getAwsAccountId}
         * @param awsAccountId The AwsAccountId of the CustomPermissions resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CustomPermissionsReference#getCustomPermissionsArn}
         * @param customPermissionsArn The ARN of the CustomPermissions resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPermissionsArn(java.lang.String customPermissionsArn) {
            this.customPermissionsArn = customPermissionsArn;
            return this;
        }

        /**
         * Sets the value of {@link CustomPermissionsReference#getCustomPermissionsName}
         * @param customPermissionsName The CustomPermissionsName of the CustomPermissions resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPermissionsName(java.lang.String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomPermissionsReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomPermissionsReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomPermissionsReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPermissionsReference {
        private final java.lang.String awsAccountId;
        private final java.lang.String customPermissionsArn;
        private final java.lang.String customPermissionsName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customPermissionsArn = software.amazon.jsii.Kernel.get(this, "customPermissionsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customPermissionsName = software.amazon.jsii.Kernel.get(this, "customPermissionsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.customPermissionsArn = java.util.Objects.requireNonNull(builder.customPermissionsArn, "customPermissionsArn is required");
            this.customPermissionsName = java.util.Objects.requireNonNull(builder.customPermissionsName, "customPermissionsName is required");
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getCustomPermissionsArn() {
            return this.customPermissionsArn;
        }

        @Override
        public final java.lang.String getCustomPermissionsName() {
            return this.customPermissionsName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("customPermissionsArn", om.valueToTree(this.getCustomPermissionsArn()));
            data.set("customPermissionsName", om.valueToTree(this.getCustomPermissionsName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_quicksight.CustomPermissionsReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomPermissionsReference.Jsii$Proxy that = (CustomPermissionsReference.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!customPermissionsArn.equals(that.customPermissionsArn)) return false;
            return this.customPermissionsName.equals(that.customPermissionsName);
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.customPermissionsArn.hashCode());
            result = 31 * result + (this.customPermissionsName.hashCode());
            return result;
        }
    }
}
