package software.amazon.awscdk.interfaces.quicksight;

/**
 * A reference to a Template resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.quicksight.*;
 * TemplateReference templateReference = TemplateReference.builder()
 *         .awsAccountId("awsAccountId")
 *         .templateArn("templateArn")
 *         .templateId("templateId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.012Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_quicksight.TemplateReference")
@software.amazon.jsii.Jsii.Proxy(TemplateReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TemplateReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AwsAccountId of the Template resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The ARN of the Template resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateArn();

    /**
     * The TemplateId of the Template resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateId();

    /**
     * @return a {@link Builder} of {@link TemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TemplateReference> {
        java.lang.String awsAccountId;
        java.lang.String templateArn;
        java.lang.String templateId;

        /**
         * Sets the value of {@link TemplateReference#getAwsAccountId}
         * @param awsAccountId The AwsAccountId of the Template resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link TemplateReference#getTemplateArn}
         * @param templateArn The ARN of the Template resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateArn(java.lang.String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        /**
         * Sets the value of {@link TemplateReference#getTemplateId}
         * @param templateId The TemplateId of the Template resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateId(java.lang.String templateId) {
            this.templateId = templateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TemplateReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TemplateReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TemplateReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateReference {
        private final java.lang.String awsAccountId;
        private final java.lang.String templateArn;
        private final java.lang.String templateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateArn = software.amazon.jsii.Kernel.get(this, "templateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateId = software.amazon.jsii.Kernel.get(this, "templateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.templateArn = java.util.Objects.requireNonNull(builder.templateArn, "templateArn is required");
            this.templateId = java.util.Objects.requireNonNull(builder.templateId, "templateId is required");
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getTemplateArn() {
            return this.templateArn;
        }

        @Override
        public final java.lang.String getTemplateId() {
            return this.templateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("templateArn", om.valueToTree(this.getTemplateArn()));
            data.set("templateId", om.valueToTree(this.getTemplateId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_quicksight.TemplateReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TemplateReference.Jsii$Proxy that = (TemplateReference.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!templateArn.equals(that.templateArn)) return false;
            return this.templateId.equals(that.templateId);
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.templateArn.hashCode());
            result = 31 * result + (this.templateId.hashCode());
            return result;
        }
    }
}
