package software.amazon.awscdk.interfaces.rds;

/**
 * A reference to a DBInstance resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.rds.*;
 * DBInstanceReference dBInstanceReference = DBInstanceReference.builder()
 *         .dbInstanceArn("dbInstanceArn")
 *         .dbInstanceIdentifier("dbInstanceIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.016Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_rds.DBInstanceReference")
@software.amazon.jsii.Jsii.Proxy(DBInstanceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DBInstanceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the DBInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceArn();

    /**
     * The DBInstanceIdentifier of the DBInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceIdentifier();

    /**
     * @return a {@link Builder} of {@link DBInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DBInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DBInstanceReference> {
        java.lang.String dbInstanceArn;
        java.lang.String dbInstanceIdentifier;

        /**
         * Sets the value of {@link DBInstanceReference#getDbInstanceArn}
         * @param dbInstanceArn The ARN of the DBInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceArn(java.lang.String dbInstanceArn) {
            this.dbInstanceArn = dbInstanceArn;
            return this;
        }

        /**
         * Sets the value of {@link DBInstanceReference#getDbInstanceIdentifier}
         * @param dbInstanceIdentifier The DBInstanceIdentifier of the DBInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceIdentifier(java.lang.String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DBInstanceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DBInstanceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DBInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBInstanceReference {
        private final java.lang.String dbInstanceArn;
        private final java.lang.String dbInstanceIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbInstanceArn = software.amazon.jsii.Kernel.get(this, "dbInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbInstanceIdentifier = software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbInstanceArn = java.util.Objects.requireNonNull(builder.dbInstanceArn, "dbInstanceArn is required");
            this.dbInstanceIdentifier = java.util.Objects.requireNonNull(builder.dbInstanceIdentifier, "dbInstanceIdentifier is required");
        }

        @Override
        public final java.lang.String getDbInstanceArn() {
            return this.dbInstanceArn;
        }

        @Override
        public final java.lang.String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbInstanceArn", om.valueToTree(this.getDbInstanceArn()));
            data.set("dbInstanceIdentifier", om.valueToTree(this.getDbInstanceIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_rds.DBInstanceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DBInstanceReference.Jsii$Proxy that = (DBInstanceReference.Jsii$Proxy) o;

            if (!dbInstanceArn.equals(that.dbInstanceArn)) return false;
            return this.dbInstanceIdentifier.equals(that.dbInstanceIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.dbInstanceArn.hashCode();
            result = 31 * result + (this.dbInstanceIdentifier.hashCode());
            return result;
        }
    }
}
