package software.amazon.awscdk.interfaces.rds;

/**
 * A reference to a DBSecurityGroupIngress resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.rds.*;
 * DBSecurityGroupIngressReference dBSecurityGroupIngressReference = DBSecurityGroupIngressReference.builder()
 *         .dbSecurityGroupIngressId("dbSecurityGroupIngressId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.031Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_rds.DBSecurityGroupIngressReference")
@software.amazon.jsii.Jsii.Proxy(DBSecurityGroupIngressReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DBSecurityGroupIngressReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the DBSecurityGroupIngress resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbSecurityGroupIngressId();

    /**
     * @return a {@link Builder} of {@link DBSecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DBSecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DBSecurityGroupIngressReference> {
        java.lang.String dbSecurityGroupIngressId;

        /**
         * Sets the value of {@link DBSecurityGroupIngressReference#getDbSecurityGroupIngressId}
         * @param dbSecurityGroupIngressId The Id of the DBSecurityGroupIngress resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroupIngressId(java.lang.String dbSecurityGroupIngressId) {
            this.dbSecurityGroupIngressId = dbSecurityGroupIngressId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DBSecurityGroupIngressReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DBSecurityGroupIngressReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DBSecurityGroupIngressReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBSecurityGroupIngressReference {
        private final java.lang.String dbSecurityGroupIngressId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbSecurityGroupIngressId = software.amazon.jsii.Kernel.get(this, "dbSecurityGroupIngressId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbSecurityGroupIngressId = java.util.Objects.requireNonNull(builder.dbSecurityGroupIngressId, "dbSecurityGroupIngressId is required");
        }

        @Override
        public final java.lang.String getDbSecurityGroupIngressId() {
            return this.dbSecurityGroupIngressId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbSecurityGroupIngressId", om.valueToTree(this.getDbSecurityGroupIngressId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_rds.DBSecurityGroupIngressReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DBSecurityGroupIngressReference.Jsii$Proxy that = (DBSecurityGroupIngressReference.Jsii$Proxy) o;

            return this.dbSecurityGroupIngressId.equals(that.dbSecurityGroupIngressId);
        }

        @Override
        public final int hashCode() {
            int result = this.dbSecurityGroupIngressId.hashCode();
            return result;
        }
    }
}
