package software.amazon.awscdk.interfaces.redshift;

/**
 * A reference to a ClusterSubnetGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.redshift.*;
 * ClusterSubnetGroupReference clusterSubnetGroupReference = ClusterSubnetGroupReference.builder()
 *         .clusterSubnetGroupName("clusterSubnetGroupName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.039Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_redshift.ClusterSubnetGroupReference")
@software.amazon.jsii.Jsii.Proxy(ClusterSubnetGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClusterSubnetGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ClusterSubnetGroupName of the ClusterSubnetGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterSubnetGroupName();

    /**
     * @return a {@link Builder} of {@link ClusterSubnetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterSubnetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterSubnetGroupReference> {
        java.lang.String clusterSubnetGroupName;

        /**
         * Sets the value of {@link ClusterSubnetGroupReference#getClusterSubnetGroupName}
         * @param clusterSubnetGroupName The ClusterSubnetGroupName of the ClusterSubnetGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSubnetGroupName(java.lang.String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterSubnetGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClusterSubnetGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterSubnetGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterSubnetGroupReference {
        private final java.lang.String clusterSubnetGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterSubnetGroupName = software.amazon.jsii.Kernel.get(this, "clusterSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterSubnetGroupName = java.util.Objects.requireNonNull(builder.clusterSubnetGroupName, "clusterSubnetGroupName is required");
        }

        @Override
        public final java.lang.String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterSubnetGroupName", om.valueToTree(this.getClusterSubnetGroupName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_redshift.ClusterSubnetGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterSubnetGroupReference.Jsii$Proxy that = (ClusterSubnetGroupReference.Jsii$Proxy) o;

            return this.clusterSubnetGroupName.equals(that.clusterSubnetGroupName);
        }

        @Override
        public final int hashCode() {
            int result = this.clusterSubnetGroupName.hashCode();
            return result;
        }
    }
}
