package software.amazon.awscdk.interfaces.rolesanywhere;

/**
 * A reference to a TrustAnchor resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.rolesanywhere.*;
 * TrustAnchorReference trustAnchorReference = TrustAnchorReference.builder()
 *         .trustAnchorArn("trustAnchorArn")
 *         .trustAnchorId("trustAnchorId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.071Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_rolesanywhere.TrustAnchorReference")
@software.amazon.jsii.Jsii.Proxy(TrustAnchorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TrustAnchorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the TrustAnchor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrustAnchorArn();

    /**
     * The TrustAnchorId of the TrustAnchor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrustAnchorId();

    /**
     * @return a {@link Builder} of {@link TrustAnchorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TrustAnchorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TrustAnchorReference> {
        java.lang.String trustAnchorArn;
        java.lang.String trustAnchorId;

        /**
         * Sets the value of {@link TrustAnchorReference#getTrustAnchorArn}
         * @param trustAnchorArn The ARN of the TrustAnchor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustAnchorArn(java.lang.String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
            return this;
        }

        /**
         * Sets the value of {@link TrustAnchorReference#getTrustAnchorId}
         * @param trustAnchorId The TrustAnchorId of the TrustAnchor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustAnchorId(java.lang.String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TrustAnchorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TrustAnchorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TrustAnchorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrustAnchorReference {
        private final java.lang.String trustAnchorArn;
        private final java.lang.String trustAnchorId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.trustAnchorArn = software.amazon.jsii.Kernel.get(this, "trustAnchorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trustAnchorId = software.amazon.jsii.Kernel.get(this, "trustAnchorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.trustAnchorArn = java.util.Objects.requireNonNull(builder.trustAnchorArn, "trustAnchorArn is required");
            this.trustAnchorId = java.util.Objects.requireNonNull(builder.trustAnchorId, "trustAnchorId is required");
        }

        @Override
        public final java.lang.String getTrustAnchorArn() {
            return this.trustAnchorArn;
        }

        @Override
        public final java.lang.String getTrustAnchorId() {
            return this.trustAnchorId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("trustAnchorArn", om.valueToTree(this.getTrustAnchorArn()));
            data.set("trustAnchorId", om.valueToTree(this.getTrustAnchorId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_rolesanywhere.TrustAnchorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TrustAnchorReference.Jsii$Proxy that = (TrustAnchorReference.Jsii$Proxy) o;

            if (!trustAnchorArn.equals(that.trustAnchorArn)) return false;
            return this.trustAnchorId.equals(that.trustAnchorId);
        }

        @Override
        public final int hashCode() {
            int result = this.trustAnchorArn.hashCode();
            result = 31 * result + (this.trustAnchorId.hashCode());
            return result;
        }
    }
}
