package software.amazon.awscdk.interfaces.route53recoverycontrol;

/**
 * A reference to a RoutingControl resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53recoverycontrol.*;
 * RoutingControlReference routingControlReference = RoutingControlReference.builder()
 *         .routingControlArn("routingControlArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.079Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53recoverycontrol.RoutingControlReference")
@software.amazon.jsii.Jsii.Proxy(RoutingControlReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RoutingControlReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The RoutingControlArn of the RoutingControl resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoutingControlArn();

    /**
     * @return a {@link Builder} of {@link RoutingControlReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RoutingControlReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RoutingControlReference> {
        java.lang.String routingControlArn;

        /**
         * Sets the value of {@link RoutingControlReference#getRoutingControlArn}
         * @param routingControlArn The RoutingControlArn of the RoutingControl resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingControlArn(java.lang.String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoutingControlReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RoutingControlReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RoutingControlReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingControlReference {
        private final java.lang.String routingControlArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routingControlArn = software.amazon.jsii.Kernel.get(this, "routingControlArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routingControlArn = java.util.Objects.requireNonNull(builder.routingControlArn, "routingControlArn is required");
        }

        @Override
        public final java.lang.String getRoutingControlArn() {
            return this.routingControlArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routingControlArn", om.valueToTree(this.getRoutingControlArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53recoverycontrol.RoutingControlReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RoutingControlReference.Jsii$Proxy that = (RoutingControlReference.Jsii$Proxy) o;

            return this.routingControlArn.equals(that.routingControlArn);
        }

        @Override
        public final int hashCode() {
            int result = this.routingControlArn.hashCode();
            return result;
        }
    }
}
