package software.amazon.awscdk.interfaces.route53recoveryreadiness;

/**
 * A reference to a ReadinessCheck resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53recoveryreadiness.*;
 * ReadinessCheckReference readinessCheckReference = ReadinessCheckReference.builder()
 *         .readinessCheckArn("readinessCheckArn")
 *         .readinessCheckName("readinessCheckName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.082Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53recoveryreadiness.ReadinessCheckReference")
@software.amazon.jsii.Jsii.Proxy(ReadinessCheckReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReadinessCheckReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ReadinessCheck resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReadinessCheckArn();

    /**
     * The ReadinessCheckName of the ReadinessCheck resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReadinessCheckName();

    /**
     * @return a {@link Builder} of {@link ReadinessCheckReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReadinessCheckReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReadinessCheckReference> {
        java.lang.String readinessCheckArn;
        java.lang.String readinessCheckName;

        /**
         * Sets the value of {@link ReadinessCheckReference#getReadinessCheckArn}
         * @param readinessCheckArn The ARN of the ReadinessCheck resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readinessCheckArn(java.lang.String readinessCheckArn) {
            this.readinessCheckArn = readinessCheckArn;
            return this;
        }

        /**
         * Sets the value of {@link ReadinessCheckReference#getReadinessCheckName}
         * @param readinessCheckName The ReadinessCheckName of the ReadinessCheck resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readinessCheckName(java.lang.String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReadinessCheckReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReadinessCheckReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReadinessCheckReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReadinessCheckReference {
        private final java.lang.String readinessCheckArn;
        private final java.lang.String readinessCheckName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.readinessCheckArn = software.amazon.jsii.Kernel.get(this, "readinessCheckArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readinessCheckName = software.amazon.jsii.Kernel.get(this, "readinessCheckName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.readinessCheckArn = java.util.Objects.requireNonNull(builder.readinessCheckArn, "readinessCheckArn is required");
            this.readinessCheckName = java.util.Objects.requireNonNull(builder.readinessCheckName, "readinessCheckName is required");
        }

        @Override
        public final java.lang.String getReadinessCheckArn() {
            return this.readinessCheckArn;
        }

        @Override
        public final java.lang.String getReadinessCheckName() {
            return this.readinessCheckName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("readinessCheckArn", om.valueToTree(this.getReadinessCheckArn()));
            data.set("readinessCheckName", om.valueToTree(this.getReadinessCheckName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53recoveryreadiness.ReadinessCheckReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReadinessCheckReference.Jsii$Proxy that = (ReadinessCheckReference.Jsii$Proxy) o;

            if (!readinessCheckArn.equals(that.readinessCheckArn)) return false;
            return this.readinessCheckName.equals(that.readinessCheckName);
        }

        @Override
        public final int hashCode() {
            int result = this.readinessCheckArn.hashCode();
            result = 31 * result + (this.readinessCheckName.hashCode());
            return result;
        }
    }
}
