package software.amazon.awscdk.interfaces.route53resolver;

/**
 * A reference to a FirewallDomainList resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53resolver.*;
 * FirewallDomainListReference firewallDomainListReference = FirewallDomainListReference.builder()
 *         .firewallDomainListArn("firewallDomainListArn")
 *         .firewallDomainListId("firewallDomainListId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.083Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53resolver.FirewallDomainListReference")
@software.amazon.jsii.Jsii.Proxy(FirewallDomainListReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FirewallDomainListReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the FirewallDomainList resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallDomainListArn();

    /**
     * The Id of the FirewallDomainList resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallDomainListId();

    /**
     * @return a {@link Builder} of {@link FirewallDomainListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirewallDomainListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FirewallDomainListReference> {
        java.lang.String firewallDomainListArn;
        java.lang.String firewallDomainListId;

        /**
         * Sets the value of {@link FirewallDomainListReference#getFirewallDomainListArn}
         * @param firewallDomainListArn The ARN of the FirewallDomainList resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallDomainListArn(java.lang.String firewallDomainListArn) {
            this.firewallDomainListArn = firewallDomainListArn;
            return this;
        }

        /**
         * Sets the value of {@link FirewallDomainListReference#getFirewallDomainListId}
         * @param firewallDomainListId The Id of the FirewallDomainList resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallDomainListId(java.lang.String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirewallDomainListReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FirewallDomainListReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirewallDomainListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirewallDomainListReference {
        private final java.lang.String firewallDomainListArn;
        private final java.lang.String firewallDomainListId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firewallDomainListArn = software.amazon.jsii.Kernel.get(this, "firewallDomainListArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.firewallDomainListId = software.amazon.jsii.Kernel.get(this, "firewallDomainListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firewallDomainListArn = java.util.Objects.requireNonNull(builder.firewallDomainListArn, "firewallDomainListArn is required");
            this.firewallDomainListId = java.util.Objects.requireNonNull(builder.firewallDomainListId, "firewallDomainListId is required");
        }

        @Override
        public final java.lang.String getFirewallDomainListArn() {
            return this.firewallDomainListArn;
        }

        @Override
        public final java.lang.String getFirewallDomainListId() {
            return this.firewallDomainListId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firewallDomainListArn", om.valueToTree(this.getFirewallDomainListArn()));
            data.set("firewallDomainListId", om.valueToTree(this.getFirewallDomainListId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53resolver.FirewallDomainListReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirewallDomainListReference.Jsii$Proxy that = (FirewallDomainListReference.Jsii$Proxy) o;

            if (!firewallDomainListArn.equals(that.firewallDomainListArn)) return false;
            return this.firewallDomainListId.equals(that.firewallDomainListId);
        }

        @Override
        public final int hashCode() {
            int result = this.firewallDomainListArn.hashCode();
            result = 31 * result + (this.firewallDomainListId.hashCode());
            return result;
        }
    }
}
