package software.amazon.awscdk.interfaces.route53resolver;

/**
 * A reference to a FirewallRuleGroupAssociation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53resolver.*;
 * FirewallRuleGroupAssociationReference firewallRuleGroupAssociationReference = FirewallRuleGroupAssociationReference.builder()
 *         .firewallRuleGroupAssociationArn("firewallRuleGroupAssociationArn")
 *         .firewallRuleGroupAssociationId("firewallRuleGroupAssociationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.083Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53resolver.FirewallRuleGroupAssociationReference")
@software.amazon.jsii.Jsii.Proxy(FirewallRuleGroupAssociationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FirewallRuleGroupAssociationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the FirewallRuleGroupAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallRuleGroupAssociationArn();

    /**
     * The Id of the FirewallRuleGroupAssociation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallRuleGroupAssociationId();

    /**
     * @return a {@link Builder} of {@link FirewallRuleGroupAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirewallRuleGroupAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FirewallRuleGroupAssociationReference> {
        java.lang.String firewallRuleGroupAssociationArn;
        java.lang.String firewallRuleGroupAssociationId;

        /**
         * Sets the value of {@link FirewallRuleGroupAssociationReference#getFirewallRuleGroupAssociationArn}
         * @param firewallRuleGroupAssociationArn The ARN of the FirewallRuleGroupAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallRuleGroupAssociationArn(java.lang.String firewallRuleGroupAssociationArn) {
            this.firewallRuleGroupAssociationArn = firewallRuleGroupAssociationArn;
            return this;
        }

        /**
         * Sets the value of {@link FirewallRuleGroupAssociationReference#getFirewallRuleGroupAssociationId}
         * @param firewallRuleGroupAssociationId The Id of the FirewallRuleGroupAssociation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallRuleGroupAssociationId(java.lang.String firewallRuleGroupAssociationId) {
            this.firewallRuleGroupAssociationId = firewallRuleGroupAssociationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirewallRuleGroupAssociationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FirewallRuleGroupAssociationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirewallRuleGroupAssociationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirewallRuleGroupAssociationReference {
        private final java.lang.String firewallRuleGroupAssociationArn;
        private final java.lang.String firewallRuleGroupAssociationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firewallRuleGroupAssociationArn = software.amazon.jsii.Kernel.get(this, "firewallRuleGroupAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.firewallRuleGroupAssociationId = software.amazon.jsii.Kernel.get(this, "firewallRuleGroupAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firewallRuleGroupAssociationArn = java.util.Objects.requireNonNull(builder.firewallRuleGroupAssociationArn, "firewallRuleGroupAssociationArn is required");
            this.firewallRuleGroupAssociationId = java.util.Objects.requireNonNull(builder.firewallRuleGroupAssociationId, "firewallRuleGroupAssociationId is required");
        }

        @Override
        public final java.lang.String getFirewallRuleGroupAssociationArn() {
            return this.firewallRuleGroupAssociationArn;
        }

        @Override
        public final java.lang.String getFirewallRuleGroupAssociationId() {
            return this.firewallRuleGroupAssociationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firewallRuleGroupAssociationArn", om.valueToTree(this.getFirewallRuleGroupAssociationArn()));
            data.set("firewallRuleGroupAssociationId", om.valueToTree(this.getFirewallRuleGroupAssociationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53resolver.FirewallRuleGroupAssociationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirewallRuleGroupAssociationReference.Jsii$Proxy that = (FirewallRuleGroupAssociationReference.Jsii$Proxy) o;

            if (!firewallRuleGroupAssociationArn.equals(that.firewallRuleGroupAssociationArn)) return false;
            return this.firewallRuleGroupAssociationId.equals(that.firewallRuleGroupAssociationId);
        }

        @Override
        public final int hashCode() {
            int result = this.firewallRuleGroupAssociationArn.hashCode();
            result = 31 * result + (this.firewallRuleGroupAssociationId.hashCode());
            return result;
        }
    }
}
