package software.amazon.awscdk.interfaces.route53resolver;

/**
 * A reference to a OutpostResolver resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.route53resolver.*;
 * OutpostResolverReference outpostResolverReference = OutpostResolverReference.builder()
 *         .outpostResolverArn("outpostResolverArn")
 *         .outpostResolverId("outpostResolverId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.087Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_route53resolver.OutpostResolverReference")
@software.amazon.jsii.Jsii.Proxy(OutpostResolverReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OutpostResolverReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the OutpostResolver resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOutpostResolverArn();

    /**
     * The Id of the OutpostResolver resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOutpostResolverId();

    /**
     * @return a {@link Builder} of {@link OutpostResolverReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OutpostResolverReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OutpostResolverReference> {
        java.lang.String outpostResolverArn;
        java.lang.String outpostResolverId;

        /**
         * Sets the value of {@link OutpostResolverReference#getOutpostResolverArn}
         * @param outpostResolverArn The ARN of the OutpostResolver resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostResolverArn(java.lang.String outpostResolverArn) {
            this.outpostResolverArn = outpostResolverArn;
            return this;
        }

        /**
         * Sets the value of {@link OutpostResolverReference#getOutpostResolverId}
         * @param outpostResolverId The Id of the OutpostResolver resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostResolverId(java.lang.String outpostResolverId) {
            this.outpostResolverId = outpostResolverId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OutpostResolverReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OutpostResolverReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OutpostResolverReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutpostResolverReference {
        private final java.lang.String outpostResolverArn;
        private final java.lang.String outpostResolverId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.outpostResolverArn = software.amazon.jsii.Kernel.get(this, "outpostResolverArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outpostResolverId = software.amazon.jsii.Kernel.get(this, "outpostResolverId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.outpostResolverArn = java.util.Objects.requireNonNull(builder.outpostResolverArn, "outpostResolverArn is required");
            this.outpostResolverId = java.util.Objects.requireNonNull(builder.outpostResolverId, "outpostResolverId is required");
        }

        @Override
        public final java.lang.String getOutpostResolverArn() {
            return this.outpostResolverArn;
        }

        @Override
        public final java.lang.String getOutpostResolverId() {
            return this.outpostResolverId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("outpostResolverArn", om.valueToTree(this.getOutpostResolverArn()));
            data.set("outpostResolverId", om.valueToTree(this.getOutpostResolverId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_route53resolver.OutpostResolverReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OutpostResolverReference.Jsii$Proxy that = (OutpostResolverReference.Jsii$Proxy) o;

            if (!outpostResolverArn.equals(that.outpostResolverArn)) return false;
            return this.outpostResolverId.equals(that.outpostResolverId);
        }

        @Override
        public final int hashCode() {
            int result = this.outpostResolverArn.hashCode();
            result = 31 * result + (this.outpostResolverId.hashCode());
            return result;
        }
    }
}
