package software.amazon.awscdk.interfaces.rum;

/**
 * A reference to a AppMonitor resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.rum.*;
 * AppMonitorReference appMonitorReference = AppMonitorReference.builder()
 *         .appMonitorName("appMonitorName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.093Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_rum.AppMonitorReference")
@software.amazon.jsii.Jsii.Proxy(AppMonitorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppMonitorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Name of the AppMonitor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppMonitorName();

    /**
     * @return a {@link Builder} of {@link AppMonitorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppMonitorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppMonitorReference> {
        java.lang.String appMonitorName;

        /**
         * Sets the value of {@link AppMonitorReference#getAppMonitorName}
         * @param appMonitorName The Name of the AppMonitor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorName(java.lang.String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppMonitorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppMonitorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppMonitorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppMonitorReference {
        private final java.lang.String appMonitorName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appMonitorName = software.amazon.jsii.Kernel.get(this, "appMonitorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appMonitorName = java.util.Objects.requireNonNull(builder.appMonitorName, "appMonitorName is required");
        }

        @Override
        public final java.lang.String getAppMonitorName() {
            return this.appMonitorName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appMonitorName", om.valueToTree(this.getAppMonitorName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_rum.AppMonitorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppMonitorReference.Jsii$Proxy that = (AppMonitorReference.Jsii$Proxy) o;

            return this.appMonitorName.equals(that.appMonitorName);
        }

        @Override
        public final int hashCode() {
            int result = this.appMonitorName.hashCode();
            return result;
        }
    }
}
