package software.amazon.awscdk.interfaces.s3;

/**
 * A reference to a AccessGrantsLocation resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.s3.*;
 * AccessGrantsLocationReference accessGrantsLocationReference = AccessGrantsLocationReference.builder()
 *         .accessGrantsLocationArn("accessGrantsLocationArn")
 *         .accessGrantsLocationId("accessGrantsLocationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.094Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_s3.AccessGrantsLocationReference")
@software.amazon.jsii.Jsii.Proxy(AccessGrantsLocationReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessGrantsLocationReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the AccessGrantsLocation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessGrantsLocationArn();

    /**
     * The AccessGrantsLocationId of the AccessGrantsLocation resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessGrantsLocationId();

    /**
     * @return a {@link Builder} of {@link AccessGrantsLocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessGrantsLocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessGrantsLocationReference> {
        java.lang.String accessGrantsLocationArn;
        java.lang.String accessGrantsLocationId;

        /**
         * Sets the value of {@link AccessGrantsLocationReference#getAccessGrantsLocationArn}
         * @param accessGrantsLocationArn The ARN of the AccessGrantsLocation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantsLocationArn(java.lang.String accessGrantsLocationArn) {
            this.accessGrantsLocationArn = accessGrantsLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link AccessGrantsLocationReference#getAccessGrantsLocationId}
         * @param accessGrantsLocationId The AccessGrantsLocationId of the AccessGrantsLocation resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessGrantsLocationId(java.lang.String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessGrantsLocationReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessGrantsLocationReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessGrantsLocationReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessGrantsLocationReference {
        private final java.lang.String accessGrantsLocationArn;
        private final java.lang.String accessGrantsLocationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessGrantsLocationArn = software.amazon.jsii.Kernel.get(this, "accessGrantsLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessGrantsLocationId = software.amazon.jsii.Kernel.get(this, "accessGrantsLocationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessGrantsLocationArn = java.util.Objects.requireNonNull(builder.accessGrantsLocationArn, "accessGrantsLocationArn is required");
            this.accessGrantsLocationId = java.util.Objects.requireNonNull(builder.accessGrantsLocationId, "accessGrantsLocationId is required");
        }

        @Override
        public final java.lang.String getAccessGrantsLocationArn() {
            return this.accessGrantsLocationArn;
        }

        @Override
        public final java.lang.String getAccessGrantsLocationId() {
            return this.accessGrantsLocationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessGrantsLocationArn", om.valueToTree(this.getAccessGrantsLocationArn()));
            data.set("accessGrantsLocationId", om.valueToTree(this.getAccessGrantsLocationId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_s3.AccessGrantsLocationReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessGrantsLocationReference.Jsii$Proxy that = (AccessGrantsLocationReference.Jsii$Proxy) o;

            if (!accessGrantsLocationArn.equals(that.accessGrantsLocationArn)) return false;
            return this.accessGrantsLocationId.equals(that.accessGrantsLocationId);
        }

        @Override
        public final int hashCode() {
            int result = this.accessGrantsLocationArn.hashCode();
            result = 31 * result + (this.accessGrantsLocationId.hashCode());
            return result;
        }
    }
}
