package software.amazon.awscdk.interfaces.s3express;

/**
 * A reference to a DirectoryBucket resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.s3express.*;
 * DirectoryBucketReference directoryBucketReference = DirectoryBucketReference.builder()
 *         .bucketName("bucketName")
 *         .directoryBucketArn("directoryBucketArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.112Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_s3express.DirectoryBucketReference")
@software.amazon.jsii.Jsii.Proxy(DirectoryBucketReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DirectoryBucketReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The BucketName of the DirectoryBucket resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

    /**
     * The ARN of the DirectoryBucket resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectoryBucketArn();

    /**
     * @return a {@link Builder} of {@link DirectoryBucketReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DirectoryBucketReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DirectoryBucketReference> {
        java.lang.String bucketName;
        java.lang.String directoryBucketArn;

        /**
         * Sets the value of {@link DirectoryBucketReference#getBucketName}
         * @param bucketName The BucketName of the DirectoryBucket resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link DirectoryBucketReference#getDirectoryBucketArn}
         * @param directoryBucketArn The ARN of the DirectoryBucket resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryBucketArn(java.lang.String directoryBucketArn) {
            this.directoryBucketArn = directoryBucketArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DirectoryBucketReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DirectoryBucketReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DirectoryBucketReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DirectoryBucketReference {
        private final java.lang.String bucketName;
        private final java.lang.String directoryBucketArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.directoryBucketArn = software.amazon.jsii.Kernel.get(this, "directoryBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            this.directoryBucketArn = java.util.Objects.requireNonNull(builder.directoryBucketArn, "directoryBucketArn is required");
        }

        @Override
        public final java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.lang.String getDirectoryBucketArn() {
            return this.directoryBucketArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucketName", om.valueToTree(this.getBucketName()));
            data.set("directoryBucketArn", om.valueToTree(this.getDirectoryBucketArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_s3express.DirectoryBucketReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DirectoryBucketReference.Jsii$Proxy that = (DirectoryBucketReference.Jsii$Proxy) o;

            if (!bucketName.equals(that.bucketName)) return false;
            return this.directoryBucketArn.equals(that.directoryBucketArn);
        }

        @Override
        public final int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + (this.directoryBucketArn.hashCode());
            return result;
        }
    }
}
