package software.amazon.awscdk.interfaces.sagemaker;

/**
 * A reference to a NotebookInstance resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.sagemaker.*;
 * NotebookInstanceReference notebookInstanceReference = NotebookInstanceReference.builder()
 *         .notebookInstanceId("notebookInstanceId")
 *         .notebookInstanceName("notebookInstanceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.153Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_sagemaker.NotebookInstanceReference")
@software.amazon.jsii.Jsii.Proxy(NotebookInstanceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NotebookInstanceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the NotebookInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNotebookInstanceId();

    /**
     * The NotebookInstanceName of the NotebookInstance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNotebookInstanceName();

    /**
     * @return a {@link Builder} of {@link NotebookInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NotebookInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NotebookInstanceReference> {
        java.lang.String notebookInstanceId;
        java.lang.String notebookInstanceName;

        /**
         * Sets the value of {@link NotebookInstanceReference#getNotebookInstanceId}
         * @param notebookInstanceId The Id of the NotebookInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notebookInstanceId(java.lang.String notebookInstanceId) {
            this.notebookInstanceId = notebookInstanceId;
            return this;
        }

        /**
         * Sets the value of {@link NotebookInstanceReference#getNotebookInstanceName}
         * @param notebookInstanceName The NotebookInstanceName of the NotebookInstance resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notebookInstanceName(java.lang.String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NotebookInstanceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NotebookInstanceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NotebookInstanceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotebookInstanceReference {
        private final java.lang.String notebookInstanceId;
        private final java.lang.String notebookInstanceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.notebookInstanceId = software.amazon.jsii.Kernel.get(this, "notebookInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notebookInstanceName = software.amazon.jsii.Kernel.get(this, "notebookInstanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.notebookInstanceId = java.util.Objects.requireNonNull(builder.notebookInstanceId, "notebookInstanceId is required");
            this.notebookInstanceName = java.util.Objects.requireNonNull(builder.notebookInstanceName, "notebookInstanceName is required");
        }

        @Override
        public final java.lang.String getNotebookInstanceId() {
            return this.notebookInstanceId;
        }

        @Override
        public final java.lang.String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("notebookInstanceId", om.valueToTree(this.getNotebookInstanceId()));
            data.set("notebookInstanceName", om.valueToTree(this.getNotebookInstanceName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_sagemaker.NotebookInstanceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NotebookInstanceReference.Jsii$Proxy that = (NotebookInstanceReference.Jsii$Proxy) o;

            if (!notebookInstanceId.equals(that.notebookInstanceId)) return false;
            return this.notebookInstanceName.equals(that.notebookInstanceName);
        }

        @Override
        public final int hashCode() {
            int result = this.notebookInstanceId.hashCode();
            result = 31 * result + (this.notebookInstanceName.hashCode());
            return result;
        }
    }
}
