package software.amazon.awscdk.interfaces.sagemaker;

/**
 * A reference to a ProcessingJob resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.interfaces.sagemaker.*;
 * ProcessingJobReference processingJobReference = ProcessingJobReference.builder()
 *         .processingJobArn("processingJobArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.153Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.interfaces.aws_sagemaker.ProcessingJobReference")
@software.amazon.jsii.Jsii.Proxy(ProcessingJobReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProcessingJobReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ProcessingJobArn of the ProcessingJob resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProcessingJobArn();

    /**
     * @return a {@link Builder} of {@link ProcessingJobReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProcessingJobReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProcessingJobReference> {
        java.lang.String processingJobArn;

        /**
         * Sets the value of {@link ProcessingJobReference#getProcessingJobArn}
         * @param processingJobArn The ProcessingJobArn of the ProcessingJob resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingJobArn(java.lang.String processingJobArn) {
            this.processingJobArn = processingJobArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProcessingJobReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProcessingJobReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProcessingJobReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessingJobReference {
        private final java.lang.String processingJobArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.processingJobArn = software.amazon.jsii.Kernel.get(this, "processingJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.processingJobArn = java.util.Objects.requireNonNull(builder.processingJobArn, "processingJobArn is required");
        }

        @Override
        public final java.lang.String getProcessingJobArn() {
            return this.processingJobArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("processingJobArn", om.valueToTree(this.getProcessingJobArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.interfaces.aws_sagemaker.ProcessingJobReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProcessingJobReference.Jsii$Proxy that = (ProcessingJobReference.Jsii$Proxy) o;

            return this.processingJobArn.equals(that.processingJobArn);
        }

        @Override
        public final int hashCode() {
            int result = this.processingJobArn.hashCode();
            return result;
        }
    }
}
